#!/bin/sh

Usage()
{
	echo "Usage: $0 <command>"
	echo "  <command>: "
	echo "		  init - initialize minupnpd"
	echo "		  remove - Remove minupnpd"
	echo "Example:"
	echo "	$0 init"
	echo "	$0 remove"
	exit 1
}

if [ "$1" != "init" -a "$1" != "remove" ]; then
	echo "Unknown command!"
	Usage
	exit 1
fi

. /sbin/global.sh
. /sbin/config.sh

IPTABLES=iptables
WAN_IF=$wan_ppp_if
killall -q miniupnpd 1>/dev/null 2>&1
rm /etc/$MINIUPNPD_FILE 1>/dev/null 2>&1

$IPTABLES -t nat -F MINIUPNPD 1>/dev/null 2>&1
#rmeoving the rule to MINIUPNPD
$IPTABLES -t nat -D PREROUTING -i $WAN_IF -j MINIUPNPD 1>/dev/null 2>&1
$IPTABLES -t nat -X MINIUPNPD 1>/dev/null 2>&1

#removing the MINIUPNPD chain for filter
$IPTABLES -t filter -F MINIUPNPD 1>/dev/null 2>&1
#adding the rule to MINIUPNPD
$IPTABLES -t filter -D FORWARD -i $WAN_IF ! -o $WAN_IF -j MINIUPNPD 1>/dev/null 2>&1
$IPTABLES -t filter -X MINIUPNPD 1>/dev/null 2>&1

if [ "$1" == "init" ]; then
	MINIUPNPD_FILE=/etc/miniupnpd.conf
	LAN_IPADDR=`nvram_get 2860 lan_ipaddr`
	IGD=`nvram_get 2860 upnpEnabled`
	WPS1=`nvram_get 2860 WscConfMode`
	WPS2=`nvram_get rtdev WscConfMode`
	WPS3=`nvram_get wifi3 WscConfMode`
	DBDC_ENABLE=`nvram_get 2860 DBDC_MODE`
	PORT=6352

	$IPTABLES -t nat -N MINIUPNPD
	$IPTABLES -t nat -A PREROUTING -i $WAN_IF -j MINIUPNPD
	$IPTABLES -t filter -N MINIUPNPD
	$IPTABLES -t filter -A FORWARD -i $WAN_IF ! -o $WAN_IF -j MINIUPNPD

	echo "ext_ifname=$WAN_IF

listening_ip=$LAN_IPADDR

port=$PORT

bitrate_up=800000000
bitrate_down=800000000

secure_mode=no

system_uptime=yes

notify_interval=30

uuid=68555350-3352-3883-2883-335030522880

serial=12345678

model_number=1

enable_upnp=no

" > $MINIUPNPD_FILE

	if [ "$DBDC_ENABLE" = "1" -a "$CONFIG_MULTI_PROFILE_SUPPORT" = "y" ]; then
		ORIG_IFS=$IFS
		IFS=";"
		export IFS;

		SSID_INDEX=0
		PORT_NUM=7777
		ANY_RA0_WPS_EN=0
		for WPS_EN in $WPS1; do
			if [ "$WPS_EN" != "" -a "$WPS_EN" != "0" ]; then
				if [ "$IGD" = "1" ]; then
					miniupnpd -m 1 -I ra$SSID_INDEX -P /var/run/miniupnpd.ra$SSID_INDEX -G -i $WAN_IF -a $LAN_IPADDR -n $PORT_NUM
				else
					miniupnpd -m 1 -I ra$SSID_INDEX -P /var/run/miniupnpd.ra$SSID_INDEX -i $WAN_IF -a $LAN_IPADDR -n $PORT_NUM
				fi
				ANY_RA0_WPS_EN=1
			fi
			SSID_INDEX=`expr $SSID_INDEX + 1`
			PORT_NUM=`expr $PORT_NUM + 1`
		done

		SSID_INDEX=0
		PORT_NUM=9999
		ANY_RAX0_WPS_EN=0
		for WPS_EN in $WPS3; do
			if [ "$WPS_EN" != "" -a "$WPS_EN" != "0" ]; then
				if [ "$IGD" == "1" -a "$ANY_RA0_WPS_EN" = "0" ]; then
					miniupnpd -m 1 -I rax$SSID_INDEX -P /var/run/miniupnpd.rax$SSID_INDEX -G -i $WAN_IF -a $LAN_IPADDR -n $PORT_NUM
				else
					miniupnpd -m 1 -I rax$SSID_INDEX -P /var/run/miniupnpd.rax$SSID_INDEX -i $WAN_IF -a $LAN_IPADDR -n $PORT_NUM
				fi
				ANY_RAX0_WPS_EN=1
			fi
			SSID_INDEX=`expr $SSID_INDEX + 1`
			PORT_NUM=`expr $PORT_NUM + 1`
		done

		IFS=$ORIG_IFS
		export IFS;
		
		if [ "$WPS2" != "" -a "$WPS2" != "0" ]; then
			if [ "$IGD" = "1" -a "$ANY_RA0_WPS_EN" = "0" -a "$ANY_RAX0_WPS_EN" = "0" ]; then
				miniupnpd -m 1 -I rai0 -P /var/run/miniupnpd.rai0 -G -i $WAN_IF -a $LAN_IPADDR -n 8888
			else
				miniupnpd -m 1 -I rai0 -P /var/run/miniupnpd.rai0 -i $WAN_IF -a $LAN_IPADDR -n 8888
			fi
		elif [ "$IGD" = "1" ]; then
			miniupnpd -G
		fi
	elif [ "$DBDC_ENABLE" = "1" -a "$CONFIG_MULTI_PROFILE_SUPPORT" != "y" ]; then
		ORIG_IFS=$IFS
		IFS=";"
		export IFS;

		SSID_INDEX=0
		PORT_NUM=7777
		ANY_RA0_WPS_EN=0
		for WPS_EN in $WPS1; do
			if [ "$WPS_EN" != "" -a "$WPS_EN" != "0" ]; then
				if [ "$IGD" == "1" ]; then
					miniupnpd -m 1 -I ra$SSID_INDEX -P /var/run/miniupnpd.ra$SSID_INDEX -G -i $WAN_IF -a $LAN_IPADDR -n $PORT_NUM
				else
					miniupnpd -m 1 -I ra$SSID_INDEX -P /var/run/miniupnpd.ra$SSID_INDEX -i $WAN_IF -a $LAN_IPADDR -n $PORT_NUM
				fi
				ANY_RA0_WPS_EN=1
			fi
			SSID_INDEX=`expr $SSID_INDEX + 1`
			PORT_NUM=`expr $PORT_NUM + 1`
		done

		IFS=$ORIG_IFS
		export IFS;
		
		if [ "$WPS2" != "" -a "$WPS2" != "0" ]; then
			if [ "$IGD" = "1" -a "$ANY_RA0_WPS_EN" = "0" ]; then
				miniupnpd -m 1 -I rai0 -P /var/run/miniupnpd.rai0 -G -i $WAN_IF -a $LAN_IPADDR -n 8888
			else
				miniupnpd -m 1 -I rai0 -P /var/run/miniupnpd.rai0 -i $WAN_IF -a $LAN_IPADDR -n 8888
			fi
		elif [ "$IGD" = "1" ]; then
			miniupnpd -G
		fi
	else
		if [ "$WPS1" != "" -a "$WPS1" != "0" ]; then
			if [ "$IGD" == "1" ]; then
				miniupnpd -m 1 -I ra0 -P /var/run/miniupnpd.ra0 -G -i $WAN_IF -a $LAN_IPADDR -n 7777
			else
				miniupnpd -m 1 -I ra0 -P /var/run/miniupnpd.ra0 -i $WAN_IF -a $LAN_IPADDR -n 7777
			fi
			if [ "$WPS2" != "" -a "$WPS2" != "0" ]; then
				miniupnpd -m 1 -I rai0 -P /var/run/miniupnpd.rai0 -i $WAN_IF -a $LAN_IPADDR -n 8888
			fi
			if [ "$WPS3" != "" -a "$WPS3" != "0" ]; then
				miniupnpd -m 1 -I rae0 -P /var/run/miniupnpd.rae0 -i $WAN_IF -a $LAN_IPADDR -n 9999
			fi
		elif [ "$WPS2" != "" -a "$WPS2" != "0" ]; then
			if [ "$IGD" == "1" ]; then
				miniupnpd -m 1 -I rai0 -P /var/run/miniupnpd.rai0 -G -i $WAN_IF -a $LAN_IPADDR -n 8888
			else
				miniupnpd -m 1 -I rai0 -P /var/run/miniupnpd.rai0 -i $WAN_IF -a $LAN_IPADDR -n 8888
			fi
			if [ "$WPS3" != "" -a "$WPS3" != "0" ]; then
				miniupnpd -m 1 -I rae0 -P /var/run/miniupnpd.rae0 -i $WAN_IF -a $LAN_IPADDR -n 9999
			fi
		elif [ "$WPS3" != "" -a "$WPS3" != "0" ]; then
			if [ "$IGD" == "1" ]; then
				miniupnpd -m 1 -I rae0 -P /var/run/miniupnpd.rae0 -G -i $WAN_IF -a $LAN_IPADDR -n 9999
			else
				miniupnpd -m 1 -I rae0 -P /var/run/miniupnpd.rae0 -i $WAN_IF -a $LAN_IPADDR -n 9999
			fi
		elif [ "$IGD" = "1" ]; then
			miniupnpd -G
		fi
	fi
fi
