/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************

    Module Name:
	mdvt.c

    Abstract:

    Revision History:
    Who          When          What
    ---------    ----------    ----------------------------------------------
*/


/*******************************************************************************
*                    E X T E R N A L   R E F E R E N C E S
********************************************************************************
*/
#ifdef WIFI_MODULE_DVT
#include "rt_config.h"

/*******************************************************************************
*                                 M A C R O S
********************************************************************************
*/
#define SET_MDVT_INIT(pmdvt) \
		((pmdvt)->init = TRUE)

#define SET_MDVT_DEINIT(pmdvt) \
		((pmdvt)->init = FALSE)

#define SET_MDVT_ENABLE(pmdvt) \
		((pmdvt)->enable = TRUE)

#define SET_MDVT_DISABLE(pmdvt) \
		((pmdvt)->enable = FALSE)

#define GET_MDVT_ENABLE_STATE(pmdvt) \
		((pmdvt)->enable)

#define GET_MDVT_INIT_STATE(pmdvt) \
		((pmdvt)->init)

/*******************************************************************************
*                             D A T A   T Y P E S
********************************************************************************
*/
typedef struct _MDVT_BYPASS_CMD_T {
	UINT_8			  ucCmdID;
	UINT_8			  ucExtCmdID;
} MDVT_BYPASS_CMD_T, *P_MDVT_BYPASS_CMD_T;

typedef struct _MDVT_MODULE_UPDATE_T {
	ENUM_MDVT_MODULE_T	eModuleId;
	RTMP_STRING			*pucParserStr;
} MDVT_MODULE_UPDATE_T, *P_MDVT_MODULE_UPDATE_T;

typedef struct _MDVT_CTRL_T {
	BOOLEAN init;
	BOOLEAN enable;
} MDVT_CTRL_T, *P_MDVT_CTRL_T;

/*******************************************************************************
*                            P U B L I C   D A T A
********************************************************************************
*/

/*******************************************************************************
*                           P R I V A T E   D A T A
********************************************************************************
*/

enum {
    /* debug commands */
	MDVT_FW_TEST = 1,
    /*END*/
};

const MDVT_BYPASS_CMD_T arMdvtBypassCmdTable[] = {
	{EXT_CID, EXT_CMD_ID_MDVT},
	/* Fw re-download by bin mode */
	{MT_TARGET_ADDRESS_LEN_REQ, 0},
	{MT_FW_START_REQ, 0},
	{CMD_ID_NIC_POWER_CTRL, 0},
	{MT_PATCH_START_REQ, 0},
	{MT_PATCH_FINISH_REQ, 0},
	{MT_PATCH_SEM_CONTROL, 0},
	{INIT_CMD_ID_CR4, 0},
	{MT_FW_SCATTER, 0},
};

size_t u4MdvtBypassCmdTableSize = sizeof(arMdvtBypassCmdTable) / sizeof(MDVT_BYPASS_CMD_T);

const MDVT_MODULE_UPDATE_T arMdvtModuleUpdateTable[] = {
	{MDVT_MODULE_WFTMAC,					"tmac"},
	{MDVT_MODULE_WFARB,						"arb"},
	{MDVT_MODULE_AGG,						"agg"},
	{MDVT_MODULE_DMA,						"dma"},
	{MDVT_MODULE_WFMIMO,					"mimo"},
	{MDVT_MODULE_WFCTRL,					"ctrl"},
	{MDVT_MODULE_WFETXBF,					"txbf"},
	{MDVT_MODULE_WFCFG,						"cfg"},
	{MDVT_MODULE_WFHIF,						"hif"},
	{MDVT_MODULE_WFOFF,						"off"},
	{MDVT_MODULE_WFON,						"on"},
	{MDVT_MODULE_WFPF,						"pf"},
	{MDVT_MODULE_WFRMAC,					"rmac"},
	{MDVT_MODULE_WFUMAC_PLE,				"ple"},
	{MDVT_MODULE_WFUMAC_PSE,				"pse"},
	{MDVT_MODULE_WFSEC,						"sec"},
	{MDVT_MODULE_WFTMAC,					"tmac"},
	{MDVT_MODULE_WFTXCR,					"txcr"},
	{MDVT_MODULE_WFMIB,						"mib"},
	{MDVT_MODULE_WFSYSON,					"syson"},
	{MDVT_MODULE_WFLPON,					"lpon"},
	{MDVT_MODULE_WFINT,						"int"},
	{MDVT_MODULE_CONNCFG,					"conncfg"},
	{MDVT_MODULE_WFMUCOP,					"mucop"},
	{MDVT_MODULE_WFMDP,						"mdp"},
	{MDVT_MODULE_WFRDM_PHYRX,				"phyrx"},
	{MDVT_MODULE_WFRDM_PHYDFS,				"phydfs"},
	{MDVT_MODULE_WFRDM_PHYRX_COMM,			"phyrxcomm"},
	{MDVT_MODULE_WFRDM_WTBLOFF,				"wtbloff"},
	{MDVT_MODULE_PHYDFE_CTRL_WF_TSSI,		"tssi"},
	{MDVT_MODULE_PHYDFE_RFINTF_WF_CMM,		"wfcmm"},
	{MDVT_MODULE_PHYRX_CTRL_WF_COMM_RDD,	"rdd"},
	{MDVT_MODULE_PHYRX_CTRL_WF_COMM_CSI,	"csi"},
	{MDVT_MODULE_PHYRX_CTRL_WF_COMM_CMM,	"cmm"},
	{MDVT_MODULE_PHYRX_CTRL_WF_COMM_TOAE,	"toae"},
	{MDVT_MODULE_PHYRX_CSD_WF_COMM_CMM,		"cmm"},
	{MDVT_MODULE_PHYRX_POST_CMM,			"postcmm"},
	{MDVT_MODULE_PHYDFS_WF_COMM_RDD,		"rdd"},
	{MDVT_MODULE_PHYRX_CTRL_TOAE,			"toae"},
	{MDVT_MODULE_PHYRX_CTRL_MURU,			"muru"},
	{MDVT_MODULE_PHYRX_CTRL_RDD,			"rdd"},
	{MDVT_MODULE_PHYRX_CTRL_MULQ,			"mulq"},
	{MDVT_MODULE_PHYRX_CTRL_CMM,			"ctrlcmm"},
	{MDVT_MODULE_PHYRX_CTRL_CSI,			"csi"},
	{MDVT_MODULE_PHYDFE_CTRL_PWR_REGU,		"requ"},
	{MDVT_MODULE_PHYRX_CTRL_BF,				"bf"},
	{MDVT_MODULE_PHYDFE_CTRL_CMM,			"dfectrlcmm"},
	{MDVT_MODULE_WFRBIST,					"rbist"},
	{MDVT_MODULE_MAX,						"all"}
};
size_t u4MdvtModuleUpdateTableSize = sizeof(arMdvtModuleUpdateTable) / sizeof(MDVT_MODULE_UPDATE_T);

/*******************************************************************************
*                              F U N C T I O N S
******************I**************************************************************
*/
static void mdvt_stop_tx_packet(struct _RTMP_ADAPTER *ad)
{
#ifdef CONFIG_AP_SUPPORT
	INT32 IdBss, MaxNumBss = ad->ApCfg.BssidNum;
	BSS_STRUCT *pMbss = &ad->ApCfg.MBSSID[MAIN_MBSSID];
#endif
	BOOLEAN Cancelled;

	RTMP_OS_NETDEV_STOP_QUEUE(ad->net_dev);
#ifdef CONFIG_AP_SUPPORT
	IF_DEV_CONFIG_OPMODE_ON_AP(ad) {
		if (MaxNumBss > MAX_MBSSID_NUM(ad))
			MaxNumBss = MAX_MBSSID_NUM(ad);

		/*  first IdBss must not be 0 (BSS0), must be 1 (BSS1) */
		for (IdBss = FIRST_MBSSID;
			 IdBss < MAX_MBSSID_NUM(ad); IdBss++) {
			if (ad->ApCfg.MBSSID[IdBss].wdev.if_dev)
				RTMP_OS_NETDEV_STOP_QUEUE(ad->ApCfg.MBSSID[IdBss].wdev.if_dev);
		}
	}

	APStop(ad, pMbss, AP_BSS_OPER_ALL);
#endif

	RTMP_SET_FLAG(ad, fRTMP_ADAPTER_DISABLE_DEQUEUEPACKET);
	RTMPCancelTimer(&ad->Mlme.PeriodicTimer, &Cancelled);
}

static void mdvt_start_tx_packet(struct _RTMP_ADAPTER *ad)
{
#ifdef CONFIG_AP_SUPPORT
	INT32 IdBss, MaxNumBss = ad->ApCfg.BssidNum;
	BSS_STRUCT *pMbss = &ad->ApCfg.MBSSID[MAIN_MBSSID];
#endif

	RTMP_CLEAR_FLAG(ad, fRTMP_ADAPTER_DISABLE_DEQUEUEPACKET);
	RTMP_OS_NETDEV_START_QUEUE(ad->net_dev);
	RTMPSetTimer(&ad->Mlme.PeriodicTimer, MLME_TASK_EXEC_INTV);

#ifdef CONFIG_AP_SUPPORT
	APStartUp(ad, pMbss, AP_BSS_OPER_ALL);

	IF_DEV_CONFIG_OPMODE_ON_AP(ad) {
		if (MaxNumBss > MAX_MBSSID_NUM(ad))
			MaxNumBss = MAX_MBSSID_NUM(ad);

		/*  first IdBss must not be 0 (BSS0), must be 1 (BSS1) */
		for (IdBss = FIRST_MBSSID; IdBss < MAX_MBSSID_NUM(ad); IdBss++) {
			if (ad->ApCfg.MBSSID[IdBss].wdev.if_dev)
				RTMP_OS_NETDEV_START_QUEUE(ad->ApCfg.MBSSID[IdBss].wdev.if_dev);
		}
	}
#endif
}

static inline P_MDVT_CTRL_T mdvt_get_ctrl(struct _RTMP_ADAPTER *ad)
{
	if (!ad)
		return NULL;

	return ad->mdvt;

}
BOOLEAN mdvt_block_command(struct _RTMP_ADAPTER *ad, struct cmd_msg *msg)
{
	int i;
	MDVT_CTRL_T *pmdvt = mdvt_get_ctrl(ad);

	if (pmdvt == NULL)
		return FALSE;

	/* Normal Case, Don't block in-band command */
	if (GET_MDVT_ENABLE_STATE(pmdvt) == FALSE)
		return FALSE;

	/* Check the bypass table */
	for (i = 0; i < u4MdvtBypassCmdTableSize; i++) {
	if ((msg->attr.ext_type == arMdvtBypassCmdTable[i].ucExtCmdID)
			&& (msg->attr.type == arMdvtBypassCmdTable[i].ucCmdID))
			return FALSE;
	}

	return TRUE;
}
void mdvt_enable(struct _RTMP_ADAPTER *ad)
{
	MDVT_CTRL_T *pmdvt = mdvt_get_ctrl(ad);

	if ((pmdvt != NULL)
		&& (GET_MDVT_INIT_STATE(pmdvt) == TRUE)
		&& (GET_MDVT_ENABLE_STATE(pmdvt) == FALSE)) {
		SET_MDVT_ENABLE(pmdvt);
		mdvt_stop_tx_packet(ad);
	}
}

void mdvt_disable(struct _RTMP_ADAPTER *ad)
{
	MDVT_CTRL_T *pmdvt = mdvt_get_ctrl(ad);

	if (pmdvt != NULL &&
	   (GET_MDVT_INIT_STATE(pmdvt) == TRUE) &&
	   (GET_MDVT_ENABLE_STATE(pmdvt) == TRUE)) {
		mdvt_start_tx_packet(ad);
		SET_MDVT_DISABLE(pmdvt);
	}
}

VOID mdvt_exit(struct _RTMP_ADAPTER *ad)
{
	MDVT_CTRL_T *pmdvt = mdvt_get_ctrl(ad);

	if (pmdvt == NULL)
		return;

	SET_MDVT_DEINIT(pmdvt);
	os_free_mem(pmdvt);
	ad->mdvt = NULL;
}

INT mdvt_init(struct _RTMP_ADAPTER *ad)
{
	P_MDVT_CTRL_T pmdvt;

	os_alloc_mem(ad, (UCHAR **)&ad->mdvt, sizeof(MDVT_CTRL_T));

	if (!ad->mdvt) {
		MTWF_LOG(DBG_CAT_ALL, DBG_SUBCAT_ALL, DBG_LVL_OFF,
		     ("%s:Allocate Fail\n", __func__));
		return FALSE;
	}

	pmdvt = ad->mdvt;
	os_zero_mem(pmdvt, sizeof(MDVT_CTRL_T));

	SET_MDVT_INIT(pmdvt);
	return 0;
}

INT SetMdvtModuleParameterProc(
	IN	PRTMP_ADAPTER	pAd,
	IN	RTMP_STRING *arg)
{
	RTMP_STRING *module_field = NULL;
	CMD_MDVT_TEST_T CmdMdvtModuleUpdate = {0};
	CHAR *set_str = NULL, *set_val = NULL;
	struct cmd_msg *msg = NULL;
	struct _CMD_ATTRIBUTE attr = {0};
	UINT8 i;
	MDVT_CTRL_T *pmdvt = mdvt_get_ctrl(pAd);

	if (!arg)
		goto show;

	set_str = strsep(&arg, "-");

	if (set_str == NULL)
		goto show;

	if (strcmp(set_str, "show") == 0)
		goto show;

	if (strcmp(set_str, "disable") == 0) {
		mdvt_disable(pAd);
		return TRUE;
	}

	for (i = 0 ; i < u4MdvtModuleUpdateTableSize; i++) {
		module_field = arMdvtModuleUpdateTable[i].pucParserStr;

		if (strcmp(set_str, module_field) == 0) {
			if ((pmdvt != NULL) &&
				GET_MDVT_ENABLE_STATE(pmdvt) == FALSE)
				mdvt_enable(pAd);

			msg = AndesAllocCmdMsg(pAd, sizeof(CMD_MDVT_TEST_T));

			if (!msg)
				return FALSE;

			SET_CMD_ATTR_MCU_DEST(attr, HOST2N9);
			SET_CMD_ATTR_TYPE(attr, EXT_CID);
			SET_CMD_ATTR_EXT_TYPE(attr, EXT_CMD_ID_MDVT);
			SET_CMD_ATTR_CTRL_FLAGS(attr, INIT_CMD_SET_AND_RETRY);
			SET_CMD_ATTR_RSP_WAIT_MS_TIME(attr, 0);
			SET_CMD_ATTR_RSP_EXPECT_SIZE(attr, 0);
			SET_CMD_ATTR_RSP_WB_BUF_IN_CALBK(attr, NULL);
			SET_CMD_ATTR_RSP_HANDLER(attr, NULL);
			AndesInitCmdMsg(msg, attr);
			CmdMdvtModuleUpdate.ucTestMode = MDVT_FW_TEST;
			CmdMdvtModuleUpdate.u2TestModule = arMdvtModuleUpdateTable[i].eModuleId;

			set_val = strsep(&arg, "-");

			if (set_val)
				CmdMdvtModuleUpdate.u2TestCaseIdx = os_str_tol(set_val, 0, 10);

			/* Append this feature */
			AndesAppendCmdMsg(msg, (char *)&CmdMdvtModuleUpdate,
							  sizeof(CMD_MDVT_TEST_T));

			MTWF_LOG(DBG_CAT_ALL, DBG_SUBCAT_ALL, DBG_LVL_OFF,
		     ("%s:Module %s Module ID = %d Test Case Idx = %d\n",
			 __func__, module_field, CmdMdvtModuleUpdate.u2TestModule,
			 CmdMdvtModuleUpdate.u2TestCaseIdx));

			AndesSendCmdMsg(pAd, msg);

			break;
		}
	}

	if (i == u4MdvtModuleUpdateTableSize)
		goto show;

	return TRUE;

show:
	MTWF_LOG(DBG_CAT_ALL, DBG_SUBCAT_ALL, DBG_LVL_OFF,
	     ("iwpriv ra0 set mdvt=(module)-(value)\n"));

	for (i = 0 ; i < u4MdvtModuleUpdateTableSize; i++) {
		MTWF_LOG(DBG_CAT_ALL, DBG_SUBCAT_ALL, DBG_LVL_OFF,
	     ("Module Name %s\n", arMdvtModuleUpdateTable[i].pucParserStr));
	}

	return TRUE;
}
#endif /* WIFI_MODULE_DVT */

