/*
 * switch_legacy.h, it's used for <<switch 753x + upstream driver>>
 * 
 * Author: Sirui Zhao <Sirui.Zhao@mediatek.com>
 */
#ifndef SWITCH_MT753X_NL_H
#define SWITCH_MT753X_NL_H

#define MT753X_GENL_NAME "mt753x"
#define MT753X_GENL_VERSION 0X1

/*add your cmd to here*/
enum {
	MT753X_CMD_UNSPEC = 0, /*Reserved*/
	MT753X_CMD_REQUEST,    /*user->kernelrequest/get-response*/
	MT753X_CMD_REPLY,      /*kernel->user event*/
	MT753X_CMD_READ,
	MT753X_CMD_WRITE,
	__MT753X_CMD_MAX,
};
#define MT753X_CMD_MAX (__MT753X_CMD_MAX - 1)

/*define attr types */
enum
{
	MT753X_ATTR_TYPE_UNSPEC = 0,
	MT753X_ATTR_TYPE_MESG, /*MT753X message*/
	MT753X_ATTR_TYPE_PHY,
	MT753X_ATTR_TYPE_PHY_DEV,
	MT753X_ATTR_TYPE_REG,
	MT753X_ATTR_TYPE_VAL,
	MT753X_ATTR_TYPE_DEV_NAME,
	MT753X_ATTR_TYPE_DEV_ID,
	__MT753X_ATTR_TYPE_MAX,
};
#define MT753X_ATTR_TYPE_MAX (__MT753X_ATTR_TYPE_MAX - 1)

struct mt753x_attr {
	int port_num;
	int phy_dev;
	int reg;
	int value;
	int type;
	char op;
	char *dev_info;
	int dev_name;
	int dev_id;
};

#if defined (CONFIG_MT753X_GSW)
int mt753x_netlink_init(void);
int reg_read_nl(struct mt753x_attr *arg, int offset, int *value);
int reg_write_nl(struct mt753x_attr *arg, int offset, int value);
int netlink_cl22_read_phy(struct mt753x_attr *arg, int port_num, int phy_addr, int *value);
int switch_nl_deinit();
#else
static int mt753x_netlink_init(void) { return -1; }
static int reg_read_nl(struct mt753x_attr *arg, int offset, int *value) { return -1; }
static int reg_write_nl(struct mt753x_attr *arg, int offset, int value) { return -1; }
static int netlink_cl22_read_phy(struct mt753x_attr *arg, int port_num, int phy_addr, int *value) { return -1; }
static int switch_nl_deinit() { return -1; }
#endif
#endif
