#ifndef _1905_LIB_IO_H
#define _1905_LIB_IO_H
#include "p1905_managerd.h"

int _1905_set_wireless_setting(struct p1905_managerd_ctx* ctx);

int _1905_wait_parse_spec_event(struct p1905_managerd_ctx* ctx, unsigned char* buf, int len, unsigned char event_type, long sec, long usec);

int _1905_event_notify(struct p1905_managerd_ctx* ctx, unsigned short event_id, unsigned char* peer_al_mac);

void _1905_set_steering_setting(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_set_client_assoc_ctrl(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_set_map_policy_config(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_ap_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac
#ifdef MAP_R2
, unsigned char periodic
#endif
);

int _1905_notify_bh_steering_req(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_assoc_sta_link_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_link_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_ap_metrics_response(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_unassoc_sta_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_set_radio_tear_down(struct p1905_managerd_ctx* ctx, unsigned char* radio_identifier);

void _1905_notify_beacon_metrics_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_controller_found(struct p1905_managerd_ctx* ctx);

int _1905_notify_channel_selection_req(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_channel_preference_query(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_channel_preference_report(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_client_steering_btm_report(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_steering_complete(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_link_metrics_response(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_assoc_sta_link_metric_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_unassoc_sta_link_metric_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_bcn_metric_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_bh_steering_rsp(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_combined_infra_metrics(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_vendor_specific_message(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_topology_rsp_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac, unsigned char* local_if_mac);

void _1905_notify_renew_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac, unsigned char renew_band);

void _1905_notify_autoconfig_rsp_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_topology_notification_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_raw_data(struct p1905_managerd_ctx *ctx, unsigned char *buf, unsigned short len);

void _1905_notify_ap_capability_report_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_ch_selection_rsp_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_operating_channel_report_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_client_capability_report_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

void _1905_notify_higher_layer_data_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_update_bss_info_per_radio(struct p1905_managerd_ctx *ctx, struct radio_info *rinfo);

void _1905_notify_combined_infrastructure_metrics_query(struct p1905_managerd_ctx* ctx,
	unsigned char* al_mac, unsigned char *peer_almac);

void _1905_notify_switch_status(struct p1905_managerd_ctx* ctx, unsigned char status);

int _1905_flash_out_config(struct p1905_managerd_ctx* ctx);

#ifdef MAP_R2
/*channel scan feature*/
int _1905_notify_ch_scan_req(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_ch_scan_rep(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_tunneled_msg(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_assoc_status_notification_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_cac_request_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_cac_terminate_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_client_disassociation_stats_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);

int _1905_notify_failed_assoc_event(struct p1905_managerd_ctx* ctx, unsigned char* al_mac);
void _1905_notify_ts_fh_setting(struct p1905_managerd_ctx *ctx, unsigned char num,
	struct ssid_2_vid_mapping *mapping);
void _1905_notify_ts_bh_setting(struct p1905_managerd_ctx *ctx, unsigned char num,
	struct ssid_2_vid_mapping *mapping);
#endif // #ifdef MAP_R2

#endif
