#ifndef _CHIPS_COMB_H
#define _CHIPS_COMB_H

/*
	This file is used for ethernet abstract layer, if customer needs to support other chips, should do as follows:
	1. Include corresponding header files in which should contain the defination of its own eth_ops.
	2. In hook_eth_ops, set the _eth_ops to the corresponding eth_ops and set ret to 0 which indicates success.
	If anything not clear, please refer to switch_layer.c related source code.
*/
extern struct eth_ops switch_layer_ops;

static inline int hook_eth_ops()
{
	int ret = ETH_ERROR_NOT_SUPPORT;

	_eth_ops = &switch_layer_ops;
	ret = 0;
	return ret;
}

#endif
