/*
 * cleopatre/application/p1905_managerd/inc/cmdu_fragment.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 *
 */
#ifndef CMDU_FRAGMENT_H
#define CMDU_FRAGMENT_H

#include <sys/queue.h>

/*data structure of RX fragment queue*/
struct fragment_list
{
    unsigned short mtype;
    unsigned short mid;
    unsigned char  fid;
    unsigned char  lastfragment;
    unsigned char  *data;
    unsigned short length;

    LIST_ENTRY(fragment_list) fragment_entry;
};

int calculate_fragment_tlvs_len(unsigned char *buf, int ref_length);
void insert_fragment_queue(unsigned short mtype, unsigned short mid,
     unsigned char fid, unsigned char lastfragment,
     unsigned short length, unsigned char *buffer);
unsigned short reassembly_fragment_queue(unsigned char *rxbuf,
     unsigned short mtype, unsigned short mid);
void add_fragment_cnt();
unsigned char get_fragment_cnt();
void delete_fragment_queue_all();


#endif /* CMDU_FRAGMENT_H */
