

#ifndef __CRYPT_BIGINTEGER_H__
#define __CRYPT_BIGINTEGER_H__

#define IN
#define OUT
#define INOUT
typedef unsigned char UINT8;
typedef unsigned int UINT;
typedef unsigned int UINT32;
typedef int INT;
typedef unsigned long long UINT64;
#define VOID void

/* BigInteger definition & structure */
#define SLIDING_WINDOW 16
typedef struct _BIG_INTEGER_STRUC
{
	char Name[10];
	UINT32 *pIntegerArray;
	UINT AllocSize;
	UINT ArrayLength;
	UINT IntegerLength;
	INT  Signed;
} BIG_INTEGER, *PBIG_INTEGER;

VOID BigInteger_Add (
    IN PBIG_INTEGER pFirstOperand,
    IN PBIG_INTEGER pSecondOperand,
    OUT PBIG_INTEGER *pBI_Result);
VOID BigInteger_Sub (
    IN PBIG_INTEGER pFirstOperand,
    IN PBIG_INTEGER pSecondOperand,
    OUT PBIG_INTEGER *pBI_Result);
VOID BigInteger_Init (
    INOUT PBIG_INTEGER *pBI);
VOID BigInteger_Bin2BI (
    IN UINT8 *pValue,
    IN UINT Length,
    OUT PBIG_INTEGER *pBI);
VOID BigInteger_Montgomery_ExpMod (
    IN PBIG_INTEGER pBI_G,
    IN PBIG_INTEGER pBI_E,
    IN PBIG_INTEGER pBI_P,
    OUT PBIG_INTEGER *pBI_Result);
VOID BigInteger_BI2Bin (
    IN PBIG_INTEGER pBI,
    OUT UINT8 *pValue,
    OUT UINT *Length);
VOID BigInteger_Free (
    IN PBIG_INTEGER *pBI);





#endif

