/*
 * cleopatre/application/p1905_managerd/inc/debug.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 *
 */

#ifndef __DEBUG_H__
#define __DEBUG_H__

#include <syslog.h>

#define DEBUG_OFF 		LOG_EMERG
#define DEBUG_ERROR		LOG_ALERT  
#define DEBUG_WARN		LOG_CRIT 
#define DEBUG_TRACE		LOG_ERR 
#define DEBUG_INFO		LOG_WARNING 

extern int debug_level;

#define debug(level,...)   \
{                                       \
	if (level <= debug_level)          \
	{                                   \
		printf("[1905Daemon][%s] ", __func__);	\
		printf(__VA_ARGS__);          \
	}                                   \
}

#define debugbyte(Level, fmt, args...)   \
{                                       \
	if (Level <= debug_level)          \
	{                                   \
		printf( fmt, ## args);          \
	}                                   \
}

#define RED(_text)  "\033[1;31m"_text"\033[0m"
#define GRN(_text)  "\033[1;32m"_text"\033[0m"
#define YLW(_text)  "\033[1;33m"_text"\033[0m"
#define BLUE(_text) "\033[1;36m"_text"\033[0m"

void hex_dump(char *str, unsigned char *pSrcBufVA, unsigned int SrcBufLen);
void hex_dump_info(char *str, unsigned char *pSrcBufVA, unsigned int SrcBufLen);
void hex_dump_all(char *str, unsigned char *pSrcBufVA, unsigned int SrcBufLen);
void set_debug_level(int level);

#endif /* __DEBUG_H__ */

