/*
 * cleopatre/application/p1905_managerd/inc/cmdu_fragment.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 *
 */
#ifndef MESSAGE_WAIT_QUEUE_H
#define MESSAGE_WAIT_QUEUE_H

#include <sys/queue.h>
#include "p1905_managerd.h"

/*data structure of RX fragment queue*/
struct msg_wait_list
{
	unsigned short mtype;
    unsigned char  *data;
    unsigned short data_len;
    LIST_ENTRY(msg_wait_list) wait_entry;
};

void init_message_wait_queue();
void insert_message_wait_queue(
	unsigned short mtype, unsigned char *data, unsigned short length);
void handle_message_wait_queue(struct p1905_managerd_ctx *ctx, unsigned char *buf);
void delete_message_wait_queue(struct p1905_managerd_ctx *ctx);
void uninit_message_wait_queue();



#endif /* MESSAGE_WAIT_QUEUE_H */
