#ifndef _NETLINK_EVENT_H
#define _NETLINK_EVENT_H

#ifndef GNU_PACKED
#define GNU_PACKED  __attribute__ ((packed))
#endif /* GNU_PACKED */

/*---------------------------------->
consistent in both kernel prog and user prog
*/
#define PORT_STATUS_GROUP    0x01
#define PORT_STATUS_NOTIFIER_PROTO 30

enum _1905_NETLINK_EVENT_TYPE {
	SWITCH_PORT_CHANGE,
};

enum _1905_NETLINK_CMD_TYPE {
	GET_SWITCH_PORT_STATUS,
};

/*common net link data structure, all 1905 netlink event should align this structure*/
struct GNU_PACKED _1905_netlink_message {
	unsigned char type;
	unsigned short len;
	unsigned char event[0];
};
/*<----------------------------------
consistent in both kernel prog and user prog
*/

int netlink_init(unsigned int pid);
int netlink_deinit(int sock);
int netlink_event_recv(int sock, unsigned char *buf, int len);
int netlink_msg_send(const unsigned char *message, int len, unsigned int dst_group);
int netlink_event_handler(void *context, struct _1905_netlink_message *event, int length);
unsigned char *get_netlink_data(unsigned char *raw, int *len);
int update_switch_port_status_by_netlink(int port_index);


#endif
