/*
 * cleopatre/application/p1905_managerd/inc/p1905_managerd.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#ifndef P1905_MANAGERD_H
#define P1905_MANAGERD_H

#include <linux/if_packet.h>
#include <netinet/in.h>
#include <net/if.h>
#include <linux/if_ether.h>
#include <sys/un.h>
#include "p1905_database.h"
//#include "../../linux/gpio.h"
#ifdef SUPPORT_WIFI
#include "wifi_utils.h"
#include "wsc_attr_tlv.h"
#include "p1905_ap_autoconfig.h"
#endif
#include "wapp_usr_intf_ctrl.h"
#include "_1905_interface.h"
#include "_1905_lib_internal.h"
#include "os.h"
#include "stack.h"
#include "ethernet_layer.h"
#include "mapfilter_if.h"
#define _1905_VERSION  	"1.0"

#define CONTROLLER 0
#define AGENT 1
#define UNKNOWN 0xff

#define WAPP_SERVER_NAME    "wapp_server"

/* use this compiler option to enable update bridge fdb for AL mac learning
 * set 1: enable
 * set 0: disbale
 */
#define UPDATE_BRIDGE_FDB_ENABLE 0//1

/** Define packet max length */
#define MAX_PKT_LEN     15360

/*define time_to_live of topology discovery database*/
#define TOPOLOGY_DISCOVERY_TTL 300 //70 seconds
#define TOPOLOGY_DEVICE_TTL 300 //2min
#define SEARCH_TIME_TTL 20 //60 seconds


/*for vendor specific*/
#define OUI_SPIDCOM     "\x00\x0c\x43"
#define OUI_LEN 3

/* for push button join notify, we must record the current stations
 * information to compare. although in PLC there can be 256 stations, but
 * we use 32 to reduce memory usage.
 */
#define MAX_STATIONS 32

#define P1905_CONF_PATH "/etc/p1905.conf"

#define PRINT_MAC(a) a[0],a[1],a[2],a[3],a[4],a[5]
/* HPAV station information, we use this structure to maintain
 * the information gotton from MME(CC_DISCOVER_LIST_CNF)
 */

#define MAX_SET_BSS_INFO_NUM 26
#define MAX_RADIO_NUM 3

/*Interface Media Type(spec 6.4.7)*/
#define IEEE802_3_GROUP   		0x0000
#define IEEE802_11_GROUP 		0x0100
#define IEEE802_11B_24G_GROUP  	0x0100
#define IEEE802_11G_24G_GROUP  	0x0101
#define IEEE802_11A_5G_GROUP  	0x0102
#define IEEE802_11N_24G_GROUP  	0x0103
#define IEEE802_11N_5G_GROUP  	0x0104
#define IEEE802_11AC_5G_GROUP  	0x0105
#define IEEE802_11AX_GROUP  	0x0108
#define IEEE1901_GROUP    		0x0200
#define MOCA_GROUP        		0x0300

#define WAPP_CTRL_PATH			"/tmp/wapp_ctrl"
typedef struct
{
    unsigned char station_num;
    unsigned char station_mac_list[MAX_STATIONS][ETH_ALEN];
    unsigned char new_station[ETH_ALEN];
} hpav_info;

#ifdef SUPPORT_WIFI
typedef struct
{
    unsigned char no_need_start_pbc;
    unsigned char station_num;
    unsigned char station_mac_list[WIFI_MAX_STATION_NUM][ETH_ALEN];
    unsigned char new_station[ETH_ALEN];

} iee802_11_info;
#endif

/* for 1905.1 push button join notification use. */
typedef struct
{
    /*store the al id from push button event notification*/
    unsigned char al_id[ETH_ALEN];
    /*strore the message id from push button event notification*/
    unsigned short mid;
    /*is_sc: 1 ==> simple connect on-going*/
    unsigned char is_sc;
    /*store the information of PLC*/
    hpav_info info;

#ifdef SUPPORT_WIFI
    /*store the information of WIFI*/
    iee802_11_info wifi_info;
#endif
} push_button_param;

struct auto_config_info {
	signed char radio_index;
	unsigned char config_number;
	WSC_CONFIG config_data[MAX_BSS_NUM];
} ;

struct set_config_bss_info{
	unsigned char mac[ETH_ALEN];
	char oper_class[4];
	char ssid[33];
	unsigned short authmode;
	unsigned short encryptype;
	char key[65];
	unsigned char wfa_vendor_extension;
	unsigned char hidden_ssid;
	unsigned short pvid;
	unsigned char pcp;
	unsigned char ssid_len;
	unsigned short vid;
};

struct _config_buf_ctrl{
	unsigned char *itf_name;
	unsigned char *config_buff;
	int len;
	struct dl_list list;
};

struct contro_conn_port {
	unsigned char is_set;
	int port_num;
	unsigned char filter_almac[ETH_ALEN];
};


#define FIRST_VITUAL_ITF 0             /*for MAP agent and contriller concurrent*/
#define MAX_FILE_PATH_LENGTH 64

/** Context structure */
struct p1905_managerd_ctx {
//by zheng.zhou
	struct wapp_usr_intf_ctrl *wapp_ctrl;
	unsigned char role;
	unsigned char br_name[IFNAMSIZ];
	char map_cfg_file[MAX_FILE_PATH_LENGTH];
	char wts_bss_cfg_file[MAX_FILE_PATH_LENGTH];
	int sock_br;                       /*bridge socket*/
	int ctrl_sock;
	int sock_inf_recv_1905[ITF_NUM];   /*recv socket array*/
	int sock_netlink;				   /*netlink socket to receive the netlink message*/
	int sock_inf_trx_test;             /*this socket is used to tx/rx packet, it is just for self test*/
	int fd_trx_test;                   /*to record peer fd*/
	int sock_internal;				   /*internal socket to receive the command from worker task*/
//	int sock_wapp;                     /*this socket is used to send request or recv event from wapp*/
//	int fd_wapp;                       /*to record peed wapp fd*/
	struct sockaddr_un sock_addr;
//    int sock_br0;   /* br0 socket */
    int sock_lldp;  /* lldp socket*/
    /*push button use*/
    int gpio_fd;
	int discovery_cnt;
	struct _1905_interface_ctrl _1905_ctrl;

    /*for golden node use*/
    int uart2_fd;
    unsigned char is_GN;
    unsigned char is_GCAP01_forward_packet;
    unsigned char is_wait_gcap05_data;
    unsigned char is_need_send_gcap05_data;
    unsigned char *gcap05_data_buffer;
    int gcap05_data_len;
    unsigned char gcap05_timer_cnt;
    uint8_t gcap05_src_mac_addr[ETH_ALEN];
    int sock_gcap05;
    struct sockaddr_ll gcap05_sll;
    unsigned char is_GCAP01_forward_tx_packet;
    unsigned char is_GCAP01_forward_rx_packet;
    unsigned char GCAP01_choose_interface[6];

    /*for sniffer use*/
    int sock_eth0;
    unsigned char sniffer_enable;

    /*for debug dump*/
    unsigned char dump_info;
//by zheng.zhou
/*no need to s*/
//    struct sockaddr_ll br0_sll;
    struct sockaddr_ll lldp_sll;

    /*for sniffer use*/
//    struct sockaddr_ll eth0_sll;

    unsigned char p1905_al_mac_addr[ETH_ALEN];

//by zheng.zhou
//move below to itf[]
//    uint8_t br0_mac_addr[ETH_ALEN];
//    uint8_t plc0_mac_addr[ETH_ALEN];
//    uint8_t eth0_mac_addr[ETH_ALEN];
#ifdef SUPPORT_WIFI
//    uint8_t wifi0_mac_addr[ETH_ALEN];
    ap_config_para ap_config;
    unsigned char uuid[16];
    unsigned char is_ap_config_by_eth;
    unsigned char *last_rx_data;
	unsigned short last_rx_buf_len;
    unsigned short last_rx_length;
    unsigned char *last_tx_data;
	unsigned short last_tx_buf_len;
    unsigned short last_tx_length;
    unsigned char *current_rx_data;
    unsigned short current_rx_length;
    unsigned char is_authenticator_exist_in_M2;
    unsigned char is_in_encrypt_settings;
    unsigned char get_config_attr_kind;
    enrolle_config_stage enrolle_state;
	renew_bss_state renew_state;
    unsigned short autoconfig_search_mid;
	unsigned char controller_search_cnt;
	controller_search_stage controller_search_state;
	WSC_CONFIG ap_config_data;

	unsigned char four_addr_support;		/*support 4 address, usually used for WiFi interfaces*/
	unsigned char concurrent;				/*support map controller and agent concurrent*/
#endif

	unsigned char Certification;	/*for Certification*/
	unsigned char MAP_Cer;			/*for MAP Certification*/

    /*push button use*/
//    union gpio_info sc_it;
    push_button_param pbc_param;
    int push_button_event_notify_by_msg;
    int push_button_trigger_by_GN;

    unsigned short mid;
    unsigned char need_relay;

    /*for link metric query/response use*/
    link_metrics_query link_metric_query_para;
    link_metrics_rep link_metric_response_para;

	/*contain the cmdu matirial to make the corresponding cmdu*/
	unsigned char send_tlv[15360];
	unsigned short send_tlv_len;
	unsigned long send_tlv_cookie;

	/*to store the recevied tlvs*/
	unsigned char* revd_tlv;
	unsigned short revd_tlv_len;
	struct os_time own_topo_rsp_update_time; 						   /*last own topology response update time*/

	int recent_cmdu_rx_if_number;
	int itf_number;
    struct p1905_interface itf[ITF_NUM];                       /*first itf is the virtual interface*/
    struct bridge_capabiltiy br_cap[BRIDGE_NUM];
    struct non_p1905_neighbor non_p1905_neighbor_dev[ITF_NUM];
    struct p1905_neighbor p1905_neighbor_dev[ITF_NUM];
    struct p1905_topology_db topology_entry;
	struct p1905_topodevice_db topodev_entry;
	struct leaf *root_leaf;									/*root leaf of the topology tree*/
	unsigned int cnt;
	unsigned char radio_number;
	char bss_priority_str[MAX_RADIO_NUM * (IFNAMSIZ + 1) * MAX_BSS_NUM];
	struct radio_info rinfo[MAX_RADIO_NUM];
	unsigned char service;
	unsigned char authenticated;
	struct auto_config_info  current_autoconfig_info;
	struct controller_info cinfo;
	struct ap_capability_db ap_cap_entry;
	struct sta_info sinfo;
	unsigned char sta_notifier;
	struct channel_setting *ch_set;
	struct channel_status *ch_stat;
	struct channel_report *ch_rep;
	/*map policy configuration*/
	struct policy_config map_policy;
	/*client assciation control of steering request*/
	struct control_policy *steer_cntrl;
	/*backhaul steering request & response*/
	struct backhaul_steer_request bsteer_req;
	struct backhaul_steer_rsp bsteer_rsp;
	/*client steering request*/
	unsigned int steer_req_len;
	struct steer_request *cli_steer_req;
#ifdef MAP_R2
	/* R2 client steering request*/
	unsigned int steer_req_len_r2;
	struct steer_request_r2 *cli_steer_req_r2;
#endif
	/*ap metrics info*/
	struct metrics_info metric_entry;
	/*store 1905 link metrics info */
	struct _1905_link_stat link_stat;
	unsigned char *pcmdu_tx_buf;         /*pointer to the DEV_SEND_1905  tx content from wapp, e.g high layer data*/
	unsigned short cmdu_tx_buf_len;      /* DEV_SEND_1905 length*/
	unsigned short cmdu_tx_msg_type;     /*type of DEV_SEND_1905*/
	unsigned char identifier[ETH_ALEN];
	SLIST_HEAD(list_head_agent, agent_list_db) agent_head;
	/*for MAP controller*/
	unsigned char peer_bss_need_config;   /*peer bss number need to do autoconfig*/
	unsigned char bss_success_config;	  /*each band bss success config num*/
	unsigned char peer_bss_rf_band;       /*peer bss rf band*/
	unsigned char current_bss_config_index;
	unsigned char bss_config_num;
	struct set_config_bss_info bss_config[MAX_SET_BSS_INFO_NUM];
	unsigned char peer_search_band;
	unsigned char band_cap;
	unsigned char rcv_chprefer_query;
	unsigned char rcv_apmetrics_query;
	unsigned char backtrace;
	unsigned char core_dump;

	unsigned char *rx_buf;
	/*for controller use*/
	stack topo_stack;/*store the pre-order travel result of topology tree*/
	unsigned char trigger_renew;
	/*for agent use*/
	unsigned char is_renew_ongoing;
	unsigned char radio_cap;
	unsigned char cur_conf_radio;
	struct _config_buf_ctrl config_buffer;
	/*used for PON*/
	struct contro_conn_port conn_port;
	SLIST_HEAD(list_head_neighbor, neighbor_list_db) query_neighbor_head;
#ifdef MAP_R2
	unsigned char map_version; /*1:DEV_TYPE_R1, 2:DEV_TYPE_R2*/
#endif
};

int ap_autoconfig_init(struct p1905_managerd_ctx *ctx);
void multi_ap_controller_search_sm(struct p1905_managerd_ctx* ctx);
void ap_autoconfig_enrolle_sm(struct p1905_managerd_ctx *ctx);
void controller_renew_bss_sm(struct p1905_managerd_ctx *ctx);

void manage_cmd_process(struct p1905_managerd_ctx *ctx, struct manage_cmd *cmd);
int common_process(struct p1905_managerd_ctx *ctx, unsigned char *buf);

#endif /* P1905_MANAGERD_H */
