/*
 * cleopatre/application/p1905_managerd/inc/wifi_utils.h
 *
 * (C) Copyright 2013 MStar Semiconductor, Inc.
 */
#ifndef WIFI_UTILS_H
#define WIFI_UTILS_H

/*WSC Encryption type, defined in wsc 2.0.2 p.114*/
#define ENCRYP_NONE 0x0001
#define ENCRYP_WEP 0x0002
#define ENCRYP_TKIP 0x0004
#define ENCRYP_AES 0x0008

/*WSC Authentication type, defined in wsc 2.0.2 p.105*/
#define AUTH_OPEN 0x0001
#define AUTH_WPA_PERSONAL 0x0002
#define AUTH_SHARED 0x0004
#define AUTH_WPA_ENTERPRISE 0x0008
#define AUTH_WPA2_ENTERPRISE 0x0010
#define AUTH_WPA2_PERSONAL 0x0020
#define AUTH_SAE_PERSONAL 0x0040

/*WSC connection type*/
#define ESS 0x1
#define IBSS 0x2

/*WSC configured status*/
#define AP_NOT_CONFIGURED 0x1
#define AP_ALREADY_CONFIGURED     0x2

#define WIFI_MAX_STATION_NUM 16

#define RADIO1 "ra0"
#define RADIO2 "rax0"

typedef enum
{
    wifi_utils_success = 0,
    wifi_utils_error,



} WIFI_UTILS_STATUS;


typedef enum
{
    rf_band_2p4G = 1,
    rf_band_5G,
} RF_BAND;


typedef struct _DH_TABLE
{
	unsigned char pub_key[192];
	unsigned char priv_key[192];
    unsigned char secu_key[192];
} DH_TABLE, *PDH_TABLE;

typedef struct _KDK_KDF_TABLE {
    unsigned char E_Nonce[16];
    unsigned char R_Nonce[16];
    unsigned char E_Mac_Addr[6];

    unsigned char AuthKey[32];
    unsigned char KeyWrapKey[16];
    unsigned char Emsk[32];

    unsigned char DH_Secu_Key[192];
} KDK_KDF_TABLE, *PKDK_KDF_TABLE;

typedef struct _KWA_TABLE {
    unsigned char AuthKey[32];
    unsigned char *EncrptData;
    unsigned int EncrptDataLen;
    unsigned char KWA[8];
} KWA_TABLE, *PKWA_TABLE;

typedef struct _AES_TABLE {
    unsigned char *PlainText;
    unsigned int PlainTextLen;
    unsigned char IV[16];
    unsigned char *CipherText;
    unsigned int CipherTextLen;

    unsigned char KeyWrapKey[16];
} AES_TABLE, *PAES_TABLE;

typedef struct _WSC_CONFIG{
    unsigned char	Ssid[32 + 1];
    unsigned short AuthMode;
    unsigned short	EncrypType;
    unsigned char	WPAKey[64 + 1];
	unsigned char map_vendor_extension;    /*store MAP controller's Muiti-AP Vendor Extesion value in M2*/
	unsigned char hidden_ssid;
} WSC_CONFIG, *PWSC_CONFIG;

WIFI_UTILS_STATUS generate_AES_CBC_encrypt_value(AES_TABLE *enc);
WIFI_UTILS_STATUS generate_kwa(KWA_TABLE *pkwa);
WIFI_UTILS_STATUS generate_DH_secu_key(DH_TABLE *pdh);
WIFI_UTILS_STATUS generate_auth_keywrap_key(KDK_KDF_TABLE *pkdk_kdf);
WIFI_UTILS_STATUS generate_AES_CBC_decrypt_value(AES_TABLE *dec);
WIFI_UTILS_STATUS generate_DH_pub_priv_key(DH_TABLE *pdh);
WIFI_UTILS_STATUS get_uuid(unsigned char uuid[]);
WIFI_UTILS_STATUS set_wsc_config(void *pctx);
WIFI_UTILS_STATUS get_wsc_config(void *pctx, WSC_CONFIG* wsc, unsigned char *wfa_vendor_extension);
WIFI_UTILS_STATUS flash_wsc_config(void *pctx);

#endif /* WIFI_UTILS_H */
