/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	wapp_cli.c

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "1905_ctrl.h"
#include "1905_cli.h"
static int _1905_set_debug_level(struct _1905_ctrl *ctrl, int argc, char *argv[]);
static int _1905_dump_security_info(struct _1905_ctrl *ctrl, int argc, char *argv[]);

static struct _1905_ctrl *ctrl_conn;
static struct _1905_cli_cmd cli_cmds[] = {
	{"help", _1905_cli_cmd_help, "command usage"},
	{"dev_send_1905", _1905_cli_send_raw_data, "send 1905 raw data to 1905 daemon"},
	{"dev_set_config", _1905_cli_set_config, "set bss info to 1905 controller"},
	{"dump_topology_info", _1905_dump_topology_info, "dump topology info"},
	{"dump_topology_tree", _1905_dump_topology_tree, "dump topology tree"},
	{"log_level", _1905_set_log_level, "set log level"},
	{"get_eth_port_type", _1905_eth_common_cmd, "get types of all ports"},
	{"get_eth_entry", _1905_eth_common_cmd, "get all ethernet entries"},
	{"find_eth_entry", _1905_eth_common_cmd, "find a specific entry from ethernet entry table"},	
	{"get_eth_port_status", _1905_eth_common_cmd, "get status of a specific eth port"},
	{"mapfilter_debug", _1905_eth_common_cmd, "get status of a specific eth port"},
	{"mapfilter_set_primary", _1905_mapfilter_common_cmd, "get status of a specific eth port"},
	{"mapfilter_set_up_path", _1905_mapfilter_common_cmd, "get status of a specific eth port"},
	{"show_PON_dev", _1905_show_PON_dev, "show device connect to the PON"},
	{"dump_security_info", _1905_dump_security_info, "dump security_info"},
	{"set_key", _1905_set_key, "set key"},
	{"set_sec_config", _1905_set_security_config, "set security config, 0x01-enable multicast encrypt, 0x02-enable unicast encrypt"},
	{"sec_log_level", _1905_set_debug_level, "set security log level"},
	{"set_debug_level", _1905_set_debug_level, "set debug level"},
	{"set_ts_config", _1905_ts_config, "set primary vlan and traffic separation policy"},
};


static int _1905_cli_open_connection(const char *ctrl_path)
{
	ctrl_conn = _1905_ctrl_open(ctrl_path);

	if (!ctrl_conn) {
		printf("_1905_cli_open fail\n");
		return -1;
	}

	return 0;
}

static void _1905_cli_close_connection(void)
{
	_1905_ctrl_close(ctrl_conn);
	ctrl_conn = NULL;
}

static int _1905_cli_cmd_help(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	struct _1905_cli_cmd *cmd;
	int cmd_num = sizeof(cli_cmds) / sizeof(struct _1905_cli_cmd);
	int i;

	cmd = cli_cmds;
	printf("1905ctrl [role] [cmd] [args]\n");
	printf("Command Usage:\n");

	for (i = 0; i < cmd_num; i++, cmd++) {
			printf("  %-60s %-50s\n", cmd->cmd, cmd->usage);
	}

	return 0;
}

static int _1905_cli_send_raw_data(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s ", argv[0]);
	i += strlen(argv[0]) + 1;

	sprintf(&cmd[i], "%s", argv[1]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_cli_set_config(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s ", argv[0]);
	i += strlen(argv[0]) + 1;

	sprintf(&cmd[i], "%s", argv[1]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_dump_topology_info(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s", argv[0]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_dump_topology_tree(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s", argv[0]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_set_log_level(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s ", argv[0]);
	i += strlen(argv[0]) + 1;
	
	sprintf(&cmd[i], "%s", argv[1]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_eth_common_cmd(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s", argv[0]);
	i += strlen(argv[0]);

	if (argv[1])
		sprintf(&cmd[i], " %s", argv[1]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_mapfilter_common_cmd(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s", argv[0]);
	i += strlen(argv[0]);

	if (argv[1]) {
		sprintf(&cmd[i], " %s", argv[1]);
		i += strlen(argv[1]) + 1;
	}
	if (argv[2])
		sprintf(&cmd[i], " %s", argv[2]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_show_PON_dev(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s", argv[0]);
	i += strlen(argv[0]);

	if (argv[1]) {
		sprintf(&cmd[i], " %s", argv[1]);
		i += strlen(argv[1]) + 1;
	}
	if (argv[2])
		sprintf(&cmd[i], " %s", argv[2]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_dump_security_info(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s", argv[0]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_set_key(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s ", argv[0]);
	i += strlen(argv[0]) + 1;

	sprintf(&cmd[i], "%s ", argv[1]); /*almac*/
	i += strlen(argv[1]) + 1;

	sprintf(&cmd[i], "%s ", argv[2]);  /*key*/
	i += strlen(argv[2]) + 1;

	sprintf(&cmd[i], "%s", argv[3]);  /*key*/
	i += strlen(argv[3]) + 1;

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

/*1905ctrl agent/controller _1905_set_security_config 0-disabled,1-multicast enable,2-unicast enable,3-both enable*/
static int _1905_set_security_config(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s %s", argv[0], argv[1]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_set_debug_level(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s %s", argv[0], argv[1]);

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

/*
**	1. set_ts_config pvlan <pvid>
**	2. set_ts_config policy {<ssid> <vid>} |
				<clean> |
				<done>
*/
static int _1905_ts_config(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	char cmd[256];
	int i = 0, ret = -1;

	memset(cmd, 0, 256);

	sprintf(&cmd[i], "%s ", argv[0]);
	i += strlen(argv[0]) + 1;

	if (argc < 3)
		return ret;

	if (!strcmp(argv[1], "pvlan")) {
		/* string "primary vlan" */
		sprintf(&cmd[i], "%s ", argv[1]);
		i += strlen(argv[1]) + 1;

		/* primary vlan id */
		sprintf(&cmd[i], "%s ", argv[2]);
		i += strlen(argv[2]) + 1;
	} else if (!strcmp(argv[1], "policy")) {
		/* string "policy" */
		sprintf(&cmd[i], "%s ", argv[1]);
		i += strlen(argv[1]) + 1;

		if ((!strcmp(argv[2], "clean")) ||
			(!strcmp(argv[2], "done"))) {
			/* string "policy" */
			sprintf(&cmd[i], "%s ", argv[2]);
			i += strlen(argv[2]) + 1;
		}
		else {
			/* ssid */
			sprintf(&cmd[i], "%s ", argv[2]);
			i += strlen(argv[2]) + 1;

			/* vlan id */
			sprintf(&cmd[i], "%s ", argv[3]);
			i += strlen(argv[3]) + 1;
		}
	} else {
		printf("not supported ts cmd %s\n", __func__);
	}

	printf("%s cmdline %s\n", __func__, cmd);

	ret = _1905_cli_command(ctrl, cmd, strlen(cmd));

	return ret;
}

static int _1905_cli_request(struct _1905_ctrl *ctrl, int argc, char *argv[])
{
	struct _1905_cli_cmd *cmd, *match = NULL;
	int ret = 0;

	cmd = cli_cmds;

	while (cmd->cmd) {
		if (strncmp(cmd->cmd, argv[0], strlen(argv[0])) == 0) {
			match = cmd;
			break;
		}
		cmd++;
	}

	if (match) {
		ret = match->cmd_handler(ctrl, argc, &argv[0]);
	} else {
		printf("Unknown command\n");
		ret = -1;
	}

	return ret;
}

int optind = 2;
int main(int argc, char *argv[])
{
	int ret = 0;
	char socket_path[64]={0};

	snprintf(socket_path,sizeof(socket_path),"/tmp/1905ctrl_%s",argv[1]);

	ret = _1905_cli_open_connection(socket_path);
	if (ret < 0)
		return ret;

	ret = _1905_cli_request(ctrl_conn, argc - optind, &argv[optind]);

	_1905_cli_close_connection();

	return ret;
}
