/*
 * cleopatre/application/p1905_managerd/src/p1905_utils.c
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <errno.h>
#include <linux/if_packet.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <syslog.h>
#include <assert.h>
#include <linux/if_ether.h>
#include "p1905_utils.h"
#include "cmdu_tlv.h"
#include <sys/queue.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <asm/types.h>
#include <linux/netlink.h>
#include <linux/socket.h>
#include <netinet/in.h>
#include "debug.h"
#include "topology.h"

#define MAX_FDB_ENTRIES 350
#define MAX_FDB_ENTRIES_ONE_TIME 256

#define PATH_PLC0_PORT_NO "/sys/class/net/plc0/brport/port_no"
#define PATH_ETH0_PORT_NO "/sys/class/net/eth0/brport/port_no"
#ifdef SUPPORT_WIFI
#define PATH_WIFI0_PORT_NO "/sys/class/net/ra0/brport/port_no"
#endif

#define BRCTL_GET_RECV_PORT_ADDR 19
#define BRCTL_SET_BRIDGE_NOT_FORWARD_DEST 20
#define MAP_SO_BASE 1905


int get_receive_port_addr(unsigned char *brname, unsigned char *inputmac,unsigned char *outputmac)
{
	int fd = 0, ret = 0;
	int size = ETH_ALEN;
	unsigned char mac[ETH_ALEN] = {0};

	fd = socket(PF_INET, SOCK_RAW, IPPROTO_RAW);
	if (!fd) {
		debug(DEBUG_ERROR, "socket create fail\n");
		return -1;
	}
	memcpy(mac, inputmac, ETH_ALEN);
	ret = getsockopt(fd, IPPROTO_IP, MAP_SO_BASE, mac, (socklen_t *)&size);
	close(fd);

	if (ret < 0) {
		debug(DEBUG_ERROR, "fail! ret(%d)\n", ret);
		return -1;
	}
	memcpy(outputmac, mac, ETH_ALEN);

	return 0;
}

int set_opt_not_forward_dest(unsigned char *inputmac)
{
	int fd = 0, ret = 0;
	int size = ETH_ALEN;
	unsigned char mac[ETH_ALEN] = {0};

	fd = socket(PF_INET, SOCK_RAW, IPPROTO_RAW);
	if (!fd) {
		debug(DEBUG_ERROR, "create socket error\n");
		return -1;
	}
	memcpy(mac, inputmac, ETH_ALEN);
	debug(DEBUG_TRACE, "not forward mac(%02x:%02x:%02x:%02x:%02x:%02x)\n",
		PRINT_MAC(mac));
	ret = setsockopt(fd, IPPROTO_IP, MAP_SO_BASE, mac, (socklen_t)size);
	close(fd);

	if (ret < 0) {
		debug(DEBUG_ERROR, "fail! ret(%d)\n", ret);
		return -1;
	}

	return 0;
}

void dump_topology_info(struct p1905_managerd_ctx *ctx)
{
	struct topology_discovery_db *tpg_db;
	struct topology_response_db  *tpr_db;
	struct device_info_db *dev_info;
	struct p1905_neighbor_device_db *p1905_dev;
	struct non_p1905_neighbor_device_list_db *non_p1905_dev;
	struct p1905_neighbor_info *neighbor_dev_info;
	struct non_p1905_neighbor_info *non_1905neighbor_info;
	struct clients_db *clis_info = NULL;
	struct associated_clients_db *bss = NULL;

	struct device_bridge_capability_db *br_cap;
	int i = 0;
	int j = 0;
	int k = 0;
	int z = 0;
	int a = 0, b = 0;
	int f = 0;

	debug(DEBUG_OFF, "====================topology discovery====================\n");
	if (!LIST_EMPTY(&ctx->topology_entry.tpddb_head)) {
	    LIST_FOREACH(tpg_db, &ctx->topology_entry.tpddb_head, tpddb_entry)
	    {
	        i++;
	        debug(DEBUG_OFF, "neighbor%d AL MAC:\n",i);
	        debug(DEBUG_OFF, "%02x:%02x:%02x:%02x:%02x:%02x\n",
				PRINT_MAC(tpg_db->al_mac));
	       	debug(DEBUG_OFF, "neighbor%d connect interface MAC:\n",i);
	        debug(DEBUG_OFF, "%02x:%02x:%02x:%02x:%02x:%02x\n",
				PRINT_MAC(tpg_db->itf_mac));
	        debug(DEBUG_OFF, "receive neighbor%d interface MAC:\n",i);
	        debug(DEBUG_OFF, "%02x:%02x:%02x:%02x:%02x:%02x eth_port[%d]\n",
				PRINT_MAC(tpg_db->receive_itf_mac), tpg_db->eth_port);
	    }
	} else {
	    debug(DEBUG_OFF, "!!!no topology discovery\n");
	}

	debug(DEBUG_OFF, "====================topology response====================\n");
	if (!SLIST_EMPTY(&ctx->topology_entry.tprdb_head)) {
	    i = 0;
	    SLIST_FOREACH(tpr_db, &ctx->topology_entry.tprdb_head, tprdb_entry)
	    {
	        i++;
	        debug(DEBUG_OFF, "device%d AL MAC(%02x:%02x:%02x:%02x:%02x:%02x)\n",
				i, PRINT_MAC(tpr_db->al_mac_addr));
	        if (!SLIST_EMPTY(&tpr_db->devinfo_head)) {
	            SLIST_FOREACH(dev_info, &tpr_db->devinfo_head, devinfo_entry)
	            {
	                j++;
	                debug(DEBUG_OFF, "device%d interface%d(%02x:%02x:%02x:%02x:%02x:%02x)\n",
						i,j,PRINT_MAC(dev_info->mac_addr));
	                debug(DEBUG_OFF, "media type = 0x%04x\n",dev_info->media_type);
	                if (dev_info->vs_info_len > 0) {
	                   debug(DEBUG_OFF, "media specific info: \n");
	                    for(k=0;k<7;k++)
	                        printf("0x%02x ",*(dev_info->vs_info + k));
	                    debug(DEBUG_OFF, "\n");
	                }

	                if (!SLIST_EMPTY(&dev_info->p1905_nbrdb_head)) {
	                    SLIST_FOREACH(p1905_dev, &dev_info->p1905_nbrdb_head, p1905_nbrdb_entry)
	                    {
	                        z++;
	                        debug(DEBUG_OFF, "p1905 neighbor device%d(%02x:%02x:%02x:%02x:%02x:%02x)\n",
								z, PRINT_MAC(p1905_dev->p1905_neighbor_al_mac));
	                        if(p1905_dev->ieee_802_1_bridge_exist) {
	                           debug(DEBUG_OFF, "802.1 bridge exist\n");
	                        }  else {
	                           debug(DEBUG_OFF, "802.1 bridge not exist\n");
	                        }

	                    }
	                    z = 0;

	                } else {
	                    debug(DEBUG_OFF, "!!!no p1905.1 neighbor device\n");
	                }

	                if (!SLIST_EMPTY(&dev_info->non_p1905_nbrdb_head)) {
	                    SLIST_FOREACH(non_p1905_dev, &dev_info->non_p1905_nbrdb_head, non_p1905_nbrdb_entry)
	                    {
	                        z++;
	                       	debug(DEBUG_OFF, "non p1905 neighbor device%d(%02x:%02x:%02x:%02x:%02x:%02x)\n",
								z, PRINT_MAC(non_p1905_dev->non_p1905_device_interface_mac));
	                    }
	                    z = 0;
	                } else {
	                    debug(DEBUG_OFF, "!!!no non-p1905.1 neighbor device\n");
	                }
	            }
	            j = 0;

	        }

	        if (!LIST_EMPTY(&tpr_db->brcap_head)) {
	            LIST_FOREACH(br_cap, &tpr_db->brcap_head, brcap_entry)
	            {
	                a++;
	                debug(DEBUG_OFF, "device%d bridge%d:\n",i,a);
	                debug(DEBUG_OFF, "interface amount = %d\n",br_cap->interface_amount);
	                if (br_cap->interface_amount > 0) {
	                    debug(DEBUG_OFF, "interface_mac_tuple:\n");
	                    for(b=0;b<(br_cap->interface_amount)*6;b++)
	                        printf("0x%x ",*((br_cap->interface_mac_tuple)+b));
	                    debug(DEBUG_OFF, "\n");
	                }
	            }
	        }
	    }
	}
	debug(DEBUG_OFF, "====================local info====================\n");
	j=0;
	f=0;
	for (i=0; i<ctx->itf_number; i++) {
		debug(DEBUG_OFF, "local MAC %d(%02x:%02x:%02x:%02x:%02x:%02x) trx_config=%02x\n",
			i, PRINT_MAC(ctx->p1905_neighbor_dev[i].local_mac_addr), ctx->itf[i].trx_config);
		if (!LIST_EMPTY(&ctx->p1905_neighbor_dev[i].p1905nbr_head)) {
			LIST_FOREACH(neighbor_dev_info, &(ctx->p1905_neighbor_dev[i].p1905nbr_head),
	                    p1905nbr_entry) {
				j++;
				debug(DEBUG_OFF, "neighbor device %d\n AL MAC(%02x:%02x:%02x:%02x:%02x:%02x)\n",
					j, PRINT_MAC(neighbor_dev_info->al_mac_addr));
				debug(DEBUG_OFF, "802.1 bridge: ");
				if(neighbor_dev_info->ieee802_1_bridge) {
				    debug(DEBUG_OFF, "yes\n");
				} else {
				    debug(DEBUG_OFF, "NO\n");
				}
			}
	    } else {
	        debug(DEBUG_OFF, "no 1905.1 neighbors!!!\n");
	    }

	    if(!LIST_EMPTY(&ctx->non_p1905_neighbor_dev[i].non_p1905nbr_head)) {
	        LIST_FOREACH(non_1905neighbor_info, &(ctx->non_p1905_neighbor_dev[i].non_p1905nbr_head),
	                    non_p1905nbr_entry)
	        {
	            f++;
	            debug(DEBUG_OFF, "non 1905 neighbor device %d MAC(%02x:%02x:%02x:%02x:%02x:%02x)\n",
					f, PRINT_MAC(non_1905neighbor_info->itf_mac_addr));
	        }
	    } else {
	        debug(DEBUG_OFF, "no non-1905.1 neighbors!!!\n");
	    }
	}
	debug(DEBUG_OFF, "====================WiFi assoc station====================\n");
	SLIST_FOREACH(bss, &ctx->ap_cap_entry.assoc_clients_head, assoc_clients_entry) {
		debug(DEBUG_OFF, "\tBSS mac (%02x:%02x:%02x:%02x:%02x:%02x) assoc sta number:%d\n",
			PRINT_MAC(bss->bssid), bss->assco_clients_num)
		SLIST_FOREACH(clis_info, &bss->clients_head, clients_entry) {
			debug(DEBUG_OFF, "\t\tstation mac:(%02x:%02x:%02x:%02x:%02x:%02x) assoc time:%d\n",
				PRINT_MAC(clis_info->mac), clis_info->time);
		}
	}

}


void print_tree_leaf_handler(void *context, void* parent_leaf, void *current_leaf, void *data)
{
	struct leaf *parent = (struct leaf*)parent_leaf;
	struct leaf *current = (struct leaf*)current_leaf;
	struct p1905_managerd_ctx *ctx = (struct p1905_managerd_ctx *)context;

	if (ctx->role == CONTROLLER) {
		 debug(DEBUG_OFF, "\t\033[1m\033[40;31m (%p)(%02x:%02x:%02x:%02x:%02x:%02x)[%02x][%02x]------>[current](%p)(%02x:%02x:%02x:%02x:%02x:%02x)[%02x][%02x]\033[0m\n",
		 	parent, PRINT_MAC(parent->al_mac), parent->config_status, parent->band_cap, current, PRINT_MAC(current->al_mac), current->config_status, current->band_cap);

	} else {
		debug(DEBUG_OFF, "\t\033[1m\033[40;31m (%p)(%02x:%02x:%02x:%02x:%02x:%02x)------>(%p)(%02x:%02x:%02x:%02x:%02x:%02x)\033[0m\n",
			parent, PRINT_MAC(parent->al_mac), current, PRINT_MAC(current->al_mac));
	}
}

void dump_topology_tree(struct p1905_managerd_ctx *ctx)
{
	trace_topology_tree_cb(ctx,ctx->root_leaf, print_tree_leaf_handler, NULL);
}


int is_in_exclude_port_list(int port, int *exclude_port, int num)
{
	int i = 0;

	for (i =0; i < num; i++) {
		if (port == exclude_port[i])
			return 1;
	}

	return 0;
}

/*debug cmd.*/
void show_PON_dev(struct p1905_managerd_ctx *ctx)
{
	struct topology_discovery_db *tpg_db = NULL;
	struct topology_discovery_db *tpg_db_tmp = NULL, *ntpg_db_tmp = NULL;
	int i = 0, j = 0;
	int exclude_port[7] = {-1};

	if (ctx->role != CONTROLLER) {
		debug(DEBUG_OFF, "need input this cmd on controller\n");
		return;
	}

    LIST_FOREACH(tpg_db, &ctx->topology_entry.tpddb_head, tpddb_entry)
    {
		i = 0;
		if (tpg_db->eth_port != -1 &&
			!is_in_exclude_port_list(tpg_db->eth_port, exclude_port, 7)) {
			tpg_db_tmp = LIST_NEXT(tpg_db, tpddb_entry);
			while(tpg_db_tmp) {
				ntpg_db_tmp = LIST_NEXT(tpg_db_tmp, tpddb_entry);
				if (tpg_db_tmp->eth_port == tpg_db->eth_port)
					i++;
				tpg_db_tmp = ntpg_db_tmp;
			}
			if (i >= 1) {
				exclude_port[j++] = tpg_db->eth_port;
				tpg_db_tmp = LIST_FIRST(&ctx->topology_entry.tpddb_head);
				while(tpg_db_tmp) {
					ntpg_db_tmp = LIST_NEXT(tpg_db_tmp, tpddb_entry);
					if (tpg_db_tmp->eth_port == tpg_db->eth_port) {
						 debug(DEBUG_OFF, "DEV(%02x:%02x:%02x:%02x:%02x:%02x)"
						 	"conncet to PON\n", PRINT_MAC(tpg_db_tmp->al_mac));
					}
					tpg_db_tmp = ntpg_db_tmp;
				}
				debug(DEBUG_OFF, "DEV(%02x:%02x:%02x:%02x:%02x:%02x)"
						 	"conncet to PON\n", PRINT_MAC(ctx->p1905_al_mac_addr));
				debug(DEBUG_OFF, "controller conncet port(%d)\n", tpg_db->eth_port);
			}
		}
    }
}

