/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	ctrl_iface_unix.h

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/

#ifndef __CTRL_IFACE_UNIX_H__
#define __CTRL_IFACE_UNIX_H__

#include <sys/un.h>
#include "driver_wext.h"

struct wapp_conf;

struct wapp_ctrl_set_param {
	const char *param;
	void (*set_param)(struct wapp_conf *conf,
					  const char *confname, 
					  char *value);
};

struct wapp_ctrl_dst {
	struct dl_list list;
	struct sockaddr_un addr;
	socklen_t addrlen;
};

struct wapp_ctrl_iface {
	int sock;
	struct dl_list w_ctrl_dst_list;
};

struct wapp_ctrl_iface *wapp_ctrl_iface_init(struct wifi_app *wapp);
void wapp_ctrl_iface_deinit(struct wifi_app *wapp);
void wapp_iface_deinit(struct wifi_app *wapp);

void wapp_ctrl_set_proxy_arp_param(struct wapp_conf *conf,
									  const char *confname,
									  char *value);
int  mtk_copy_file (const char *src, const char *dst);

#endif /* __CTRL_IFACE_UNIX_H__ */
