
#include "includes.h"
#include "common.h"
#include "rtdot1x.h"

void bin_clear_free(void *bin, size_t len)
{
        if (bin) {
                memset(bin, 0, len);
                free(bin);
        }
}

extern u32 	RTDebugLevel;	
void hex_dump(char *str, const unsigned char *pSrcBufVA, unsigned int SrcBufLen)
{
	unsigned char *pt;
	int x;

	if (RTDebugLevel < RT_DEBUG_TRACE)
		return;
	
	pt = pSrcBufVA;
	printf("%s: %p, len = %d\n", str, pSrcBufVA, SrcBufLen);

	for (x = 0; x < SrcBufLen; x++) {
		if (x % 16 == 0)
			printf("0x%04x : ", x);

		printf("%02x ", ((unsigned char)pt[x]));

		if (x % 16 == 15)
			printf("\n");
	}

	printf("\n");
}

void * os_memdup(const void *src, size_t len)
{
        void *r = malloc(len);

        if (r)
                memcpy(r, src, len);
        return r;
}

void * os_zalloc(size_t size)
{
        void *ptr = malloc(size);
        if (ptr)
                memset(ptr, 0, size);
        return ptr;
}

int os_get_random(unsigned char *buf, size_t len)
{
	FILE *f;
	size_t rc;

	f = fopen("/dev/urandom", "rb");
	if (f == NULL) {
		printf("Could not open /dev/urandom.\n");
		return -1;
	}

	rc = fread(buf, 1, len, f);
	fclose(f);

	return rc != len ? -1 : 0;
}
