/*
 * Decompiled with CFR 0.152.
 */
package net.nlanr.jperf.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import net.nlanr.jperf.core.IPerfProperties;
import net.nlanr.jperf.core.IperfSpeedUnit;
import net.nlanr.jperf.core.IperfThread;
import net.nlanr.jperf.core.IperfUnit;
import net.nlanr.jperf.core.Measurement;
import net.nlanr.jperf.core.TosOption;
import net.nlanr.jperf.ui.DoubleSpinner;
import net.nlanr.jperf.ui.FormLayoutBuilder;
import net.nlanr.jperf.ui.FormLayoutColumn;
import net.nlanr.jperf.ui.IntegerSpinner;
import net.nlanr.jperf.ui.JPerfAboutPanel;
import net.nlanr.jperf.ui.chart.IPerfChartPanel;
import net.nlanr.jperf.ui.chart.SeriesColorGenerator;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jfree.ui.ExtensionFileFilter;

public class JPerfUI
extends JFrame
implements ActionListener,
KeyListener,
ChangeListener,
WindowListener {
    private JPerfAboutPanel aboutPanel;
    private JMenuBar menuBar;
    private JMenu menuJPerf;
    private JMenuItem menuJPerfOpen;
    private JMenuItem menuJPerfSaveAs;
    private JMenuItem menuJPerfRestoreDefaults;
    private JMenuItem menuJPerfAbout;
    private JMenuItem menuJPerfQuit;
    private JSplitPane centerPanel;
    private JTabbedPane tabbedPane;
    private JScrollPane outputScrollPane;
    private JTextArea output;
    private JTextField iperfCommandLabel;
    private JRadioButton serverModeRadioButton;
    private JRadioButton clientModeRadioButton;
    private JCheckBox lb_clientLimit;
    private JLabel lb_serverAddress;
    private JLabel lb_serverPort;
    private JLabel lb_listenPort;
    private JLabel lb_simultaneousConnectionsNumber;
    private JLabel lb_connectionsLimitNumber;
    private JTextField serverAddress;
    private JTextField clientLimit;
    private IntegerSpinner serverPort;
    private IntegerSpinner listenPort;
    private IntegerSpinner simultaneousConnectionsNumber;
    private IntegerSpinner connectionsLimitNumber;
    private JButton startIperf;
    private JButton stopIperf;
    private JButton restoreDefaults;
    private JButton saveConfiguration;
    private JButton loadConfiguration;
    private JRadioButton tcpRadioButton;
    private JRadioButton udpRadioButton;
    private JCheckBox lb_tcpBufferLength;
    private DoubleSpinner tcpBufferLength;
    private JComboBox tcpBufferSizeUnit;
    private JCheckBox lb_tcpWindowSize;
    private DoubleSpinner tcpWindowSize;
    private JComboBox tcpWindowSizeUnit;
    private JCheckBox lb_mss;
    private DoubleSpinner mss;
    private JComboBox mssUnit;
    private JCheckBox lb_udpBufferSize;
    private DoubleSpinner udpBufferSize;
    private JComboBox udpBufferSizeUnit;
    private JCheckBox lb_udpPacketSize;
    private DoubleSpinner udpPacketSize;
    private JComboBox udpPacketSizeUnit;
    private JLabel lb_udpBandwidth;
    private DoubleSpinner udpBandwidth;
    private JComboBox udpBandwidthUnit;
    private JCheckBox tcpNoDelay;
    private JLabel lb_bindHost;
    private JLabel lb_TTL;
    private JTextField bindhost;
    private IntegerSpinner TTL;
    private JComboBox tos;
    private JCheckBox printMSS;
    private JTextField representativeFile;
    private IntegerSpinner transmit;
    private JComboBox formatList;
    private IntegerSpinner interval;
    private ButtonGroup iperfModeButtonGroup;
    private ButtonGroup protocolButtonGroup;
    private JRadioButton transmitBytesRadioButton;
    private JRadioButton transmitSecondsRadioButton;
    private JCheckBox ipv6;
    private IperfThread iperf;
    private JCheckBox alwaysClearOutput;
    private JButton clearOutputButton;
    private JButton saveOutputButton;
    private JCheckBox compatibilityMode;
    private IntegerSpinner testPort;
    private JCheckBox dualMode;
    private JCheckBox tradeMode;
    private JButton browse;
    private float iperfVersion;
    private JToolBar toolbar;
    private JLabel lb_transmit;
    private JLabel lb_tos;
    private JLabel lb_representativeFile;
    private JLabel lb_testingMode;
    private JLabel lb_testPort;
    private JLabel lb_outputFormat;
    private JLabel lb_reportInterval;
    private String options;
    private String version;
    private String iperfCommand;
    private IPerfProperties defaultConfiguration = new IPerfProperties(true);
    private JFileChooser saveFileChooser;
    private JFileChooser loadFileChooser;
    private JPanel quickStartPanel = null;
    private JPanel applicationPanel = null;
    private JPanel transportPanel = null;
    private JPanel tcpPanel = null;
    private JPanel udpPanel = null;
    private JPanel ipPanel = null;
    private JPanel outputPanel = null;
    private IPerfChartPanel chartPanel = null;

    public JPerfUI(String string, String string2) {
        super("JPerf 2.0.2 - Network performance measurement graphical tool");
        this.iperfCommand = string;
        this.version = string2;
        String[] stringArray = string2.split(" ");
        String string3 = stringArray[2].replace('.', '-');
        String[] stringArray2 = string3.split("-");
        this.iperfVersion = new Float(stringArray2[1]).floatValue();
        this.iperfVersion = (float)((double)this.iperfVersion / 10.0);
        this.iperfVersion += new Float(stringArray2[0]).floatValue();
        this.init();
        this.applyConfiguration(this.defaultConfiguration);
        this.chartPanel.start();
        this.setDefaultCloseOperation(3);
        this.setSize(970, 700);
        this.setVisible(true);
        this.serverAddress.grabFocus();
    }

    private void applyConfiguration(IPerfProperties iPerfProperties) {
        boolean bl = iPerfProperties.getString("mode", "client").toLowerCase().trim().equals("server");
        this.setServerModeSelected(bl);
        this.setClientModeSelected(!bl);
        if (bl) {
            this.serverModeRadioButton.doClick();
        } else {
            this.clientModeRadioButton.doClick();
        }
        this.serverAddress.setText(iPerfProperties.getString("server-address", ""));
        this.serverPort.setValue(iPerfProperties.getInteger("server-port", 5001));
        this.lb_clientLimit.setSelected(iPerfProperties.getBoolean("client-limit-enabled", false));
        this._lb_clientLimit_actionPerformed();
        this.clientLimit.setText(iPerfProperties.getString("client-limit", ""));
        this.listenPort.setValue(iPerfProperties.getInteger("listen-port", 5001));
        this.simultaneousConnectionsNumber.setValue(iPerfProperties.getInteger("serverside-parallel-streams", 1));
        this.connectionsLimitNumber.setValue(iPerfProperties.getInteger("clientside-parallel-streams", 0));
        this.compatibilityMode.setSelected(iPerfProperties.getBoolean("compatibility-mode-enabled", false));
        this._compatibilityMode_actionPerformed();
        this.transmit.setValue(iPerfProperties.getInteger("transmit-value", 10));
        boolean bl2 = iPerfProperties.getString("transmit-unit", "seconds").trim().toLowerCase().equals("seconds");
        this.transmitSecondsRadioButton.setSelected(bl2);
        this.transmitBytesRadioButton.setSelected(!bl2);
        if (bl2) {
            this._transmitSecondsRadioButton_actionPerformed();
        } else {
            this._transmitBytesRadioButton_actionPerformed();
        }
        this.formatList.setSelectedItem((Object)iPerfProperties.getUnit("output-format", IPerfProperties.DEFAULT_OUTPUT_FORMAT));
        this.interval.setValue(iPerfProperties.getInteger("report-interval", 1));
        this.dualMode.setSelected(iPerfProperties.getBoolean("test-mode-dual-enabled", false));
        this._dualMode_actionPerformed();
        this.tradeMode.setSelected(iPerfProperties.getBoolean("test-mode-dual-enabled", false));
        this._tradeMode_actionPerformed();
        this.testPort.setValue(iPerfProperties.getInteger("test-mode-port", 5001));
        this.printMSS.setSelected(iPerfProperties.getBoolean("print-mss-enabled", false));
        this._printMSS_actionPerformed();
        boolean bl3 = iPerfProperties.getString("transport-protocol", "tcp").equals("udp");
        this.setUDPOptionsEnabled(bl3);
        this.setTCPOptionsEnabled(!bl3);
        if (bl3) {
            this.udpRadioButton.doClick();
        } else {
            this.tcpRadioButton.doClick();
        }
        this.lb_tcpBufferLength.setSelected(iPerfProperties.getBoolean("tcp-buffer-length-enabled", false));
        this.tcpBufferLength.setValue(iPerfProperties.getDouble("tcp-buffer-length", 2.0));
        this.tcpBufferSizeUnit.setSelectedItem((Object)iPerfProperties.getUnit("tcp-buffer-length-unit", IPerfProperties.DEFAULT_TCP_BUFFER_LENGTH_UNIT));
        this._lb_tcpBufferLength_actionPerformed();
        this.lb_tcpWindowSize.setSelected(iPerfProperties.getBoolean("tcp-window-size-enabled", false));
        this.tcpWindowSize.setValue(iPerfProperties.getDouble("tcp-window-size", 56.0));
        this.tcpWindowSizeUnit.setSelectedItem((Object)iPerfProperties.getUnit("tcp-window-size-unit", IPerfProperties.DEFAULT_TCP_WINDOW_SIZE_UNIT));
        this._lb_tcpWindowSize_actionPerformed();
        this.lb_mss.setSelected(iPerfProperties.getBoolean("tcp-mss-enabled", false));
        this.mss.setValue(iPerfProperties.getDouble("tcp-mss", 1.0));
        this.mssUnit.setSelectedItem((Object)iPerfProperties.getUnit("tcp-mss-unit", IPerfProperties.DEFAULT_TCP_MSS_UNIT));
        this._lb_mss_actionPerformed();
        this.tcpNoDelay.setSelected(iPerfProperties.getBoolean("tcp-no-delay-enabled", false));
        this._tcpNoDelay_actionPerformed();
        this.udpBandwidth.setValue(iPerfProperties.getDouble("udp-bandwidth", 1.0));
        this.udpBandwidthUnit.setSelectedItem((Object)iPerfProperties.getSpeedUnit("udp-bandwidth-unit", IPerfProperties.DEFAULT_UDP_BANDWIDTH_UNIT));
        this.lb_udpBufferSize.setSelected(iPerfProperties.getBoolean("udp-buffer-size-enabled", false));
        this.udpBufferSize.setValue(iPerfProperties.getDouble("udp-buffer-size", 41.0));
        this.udpBufferSizeUnit.setSelectedItem((Object)iPerfProperties.getUnit("udp-buffer-size-unit", IPerfProperties.DEFAULT_UDP_BUFFER_SIZE_UNIT));
        this._lb_udpBufferSize_actionPerformed();
        this.lb_udpPacketSize.setSelected(iPerfProperties.getBoolean("udp-packet-size-enabled", false));
        this.udpPacketSize.setValue(iPerfProperties.getDouble("udp-packet-size", 1500.0));
        this.udpPacketSizeUnit.setSelectedItem((Object)iPerfProperties.getUnit("udp-packet-size-unit", IPerfProperties.DEFAULT_UDP_PACKET_SIZE_UNIT));
        this._lb_udpPacketSize_actionPerformed();
        this.TTL.setValue(iPerfProperties.getInteger("ttl", 1));
        this.tos.setSelectedItem((Object)iPerfProperties.getTosOption("tos", IPerfProperties.DEFAULT_TOS));
        this.bindhost.setText(iPerfProperties.getString("bind-to-host", ""));
        this.ipv6.setSelected(!iPerfProperties.getBoolean("ipv6-enabled", false));
        this.ipv6.doClick();
    }

    private IPerfProperties getCurrentConfiguration() {
        IPerfProperties iPerfProperties = new IPerfProperties(true);
        iPerfProperties.put("mode", this.serverModeRadioButton.isSelected() ? "server" : "client");
        iPerfProperties.put("server-address", this.serverAddress.getText());
        iPerfProperties.put("server-port", this.serverPort.getValue());
        iPerfProperties.put("client-limit-enabled", this.lb_clientLimit.isSelected());
        iPerfProperties.put("client-limit", this.clientLimit.getText());
        iPerfProperties.put("listen-port", this.listenPort.getValue());
        iPerfProperties.put("serverside-parallel-streams", this.simultaneousConnectionsNumber.getValue());
        iPerfProperties.put("clientside-parallel-streams", this.connectionsLimitNumber.getValue());
        iPerfProperties.put("compatibility-mode-enabled", this.compatibilityMode.isSelected());
        iPerfProperties.put("transmit-value", this.transmit.getValue());
        iPerfProperties.put("transmit-unit", this.transmitSecondsRadioButton.isSelected() ? "seconds" : "bytes");
        iPerfProperties.put("output-format", (IperfUnit)((Object)this.formatList.getSelectedItem()));
        iPerfProperties.put("report-interval", this.interval.getValue());
        iPerfProperties.put("test-mode-dual-enabled", this.dualMode.isSelected());
        iPerfProperties.put("test-mode-trade-enabled", this.tradeMode.isSelected());
        iPerfProperties.put("test-mode-port", this.testPort.getValue());
        iPerfProperties.put("print-mss-enabled", this.printMSS.isSelected());
        iPerfProperties.put("transport-protocol", this.udpRadioButton.isSelected() ? "udp" : "tcp");
        iPerfProperties.put("tcp-buffer-length-enabled", this.lb_tcpBufferLength.isSelected());
        iPerfProperties.put("tcp-buffer-length", this.tcpBufferLength.getValue());
        iPerfProperties.put("tcp-buffer-length-unit", (IperfUnit)((Object)this.tcpBufferSizeUnit.getSelectedItem()));
        iPerfProperties.put("tcp-window-size-enabled", this.lb_tcpWindowSize.isSelected());
        iPerfProperties.put("tcp-window-size", this.tcpWindowSize.getValue());
        iPerfProperties.put("tcp-window-size-unit", (IperfUnit)((Object)this.tcpWindowSizeUnit.getSelectedItem()));
        iPerfProperties.put("tcp-mss-enabled", this.lb_mss.isSelected());
        iPerfProperties.put("tcp-mss", this.mss.getValue());
        iPerfProperties.put("tcp-mss-unit", (IperfUnit)((Object)this.mssUnit.getSelectedItem()));
        iPerfProperties.put("tcp-no-delay-enabled", this.tcpNoDelay.isSelected());
        iPerfProperties.put("udp-bandwidth", this.udpBandwidth.getValue());
        iPerfProperties.put("udp-bandwidth-unit", (IperfSpeedUnit)((Object)this.udpBandwidthUnit.getSelectedItem()));
        iPerfProperties.put("udp-buffer-size-enabled", this.lb_udpBufferSize.isSelected());
        iPerfProperties.put("udp-buffer-size", this.udpBufferSize.getValue());
        iPerfProperties.put("udp-buffer-size-unit", (IperfUnit)((Object)this.udpBufferSizeUnit.getSelectedItem()));
        iPerfProperties.put("udp-packet-size-enabled", this.lb_udpPacketSize.isSelected());
        iPerfProperties.put("udp-packet-size", this.udpPacketSize.getValue());
        iPerfProperties.put("udp-packet-size-unit", (IperfUnit)((Object)this.udpPacketSizeUnit.getSelectedItem()));
        iPerfProperties.put("ttl", this.TTL.getValue());
        iPerfProperties.put("tos", (TosOption)((Object)this.tos.getSelectedItem()));
        iPerfProperties.put("bind-to-host", this.bindhost.getText());
        iPerfProperties.put("ipv6-enabled", this.ipv6.isSelected());
        return iPerfProperties;
    }

    private void setClientModeSelected(boolean bl) {
        this.serverAddress.setEnabled(bl);
        this.lb_serverAddress.setEnabled(bl);
        this.lb_serverPort.setEnabled(bl);
        this.serverPort.setEnabled(bl);
        this.lb_simultaneousConnectionsNumber.setEnabled(bl);
        this.simultaneousConnectionsNumber.setEnabled(bl);
        this.lb_representativeFile.setEnabled((double)this.iperfVersion >= 1.2 && bl);
        this.representativeFile.setEnabled((double)this.iperfVersion >= 1.2 && bl);
        this.browse.setEnabled((double)this.iperfVersion >= 1.2 && bl);
        this.lb_testingMode.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.dualMode.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.tradeMode.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.lb_testPort.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
        this.testPort.setEnabled(!this.compatibilityMode.isSelected() && (double)this.iperfVersion >= 1.7 && bl);
    }

    private void setServerModeSelected(boolean bl) {
        this.lb_clientLimit.setEnabled(false);
        this.clientLimit.setEnabled(false);
        this.lb_connectionsLimitNumber.setEnabled(false);
        this.connectionsLimitNumber.setEnabled(false);
        this.lb_transmit.setEnabled(!bl);
        this.transmit.setEnabled(!bl);
        this.transmitSecondsRadioButton.setEnabled(!bl);
        this.transmitBytesRadioButton.setEnabled(!bl);
        this.lb_testingMode.setEnabled(!bl);
        this.dualMode.setEnabled(!bl);
        this.lb_testPort.setEnabled(!bl);
        this.tradeMode.setEnabled(!bl);
        this.testPort.setEnabled(!bl);
        this.lb_representativeFile.setEnabled(!bl);
        this.representativeFile.setEnabled(!bl);
        this.browse.setEnabled(!bl);
        this.lb_udpBandwidth.setEnabled(!bl && this.udpRadioButton.isSelected());
        this.udpBandwidth.setEnabled(!bl && this.udpRadioButton.isSelected());
        this.udpBandwidthUnit.setEnabled(!bl && this.udpRadioButton.isSelected());
        this.lb_tos.setEnabled(!bl);
        this.tos.setEnabled(!bl);
        this.lb_TTL.setEnabled(!bl);
        this.TTL.setEnabled(!bl);
        if ((double)this.iperfVersion >= 1.7) {
            this.lb_clientLimit.setEnabled(bl);
            this.clientLimit.setEnabled(bl);
            this.lb_connectionsLimitNumber.setEnabled(bl);
            this.connectionsLimitNumber.setEnabled(bl);
        }
        this.lb_listenPort.setEnabled(bl);
        this.listenPort.setEnabled(bl);
    }

    private JPanel getQuickStartPanel() {
        if (this.quickStartPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(5, new FormLayoutColumn(FormLayoutBuilder.Alignment.left, true));
            this.iperfCommandLabel = new JTextField("");
            this.iperfCommandLabel.setEditable(false);
            formLayoutBuilder.addCell(new JLabel("Iperf command:"));
            formLayoutBuilder.addCell(this.iperfCommandLabel, 5);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addCell(new JLabel("Choose iPerf Mode:"));
            this.clientModeRadioButton = new JRadioButton("Client");
            this.clientModeRadioButton.setOpaque(false);
            this.clientModeRadioButton.setSelected(true);
            this.clientModeRadioButton.setActionCommand("client");
            this.clientModeRadioButton.addActionListener(this);
            this.clientModeRadioButton.setToolTipText("Run Iperf as a client   (command line: -c)");
            formLayoutBuilder.addCell(this.clientModeRadioButton);
            this.lb_serverAddress = new JLabel("Server address");
            this.lb_serverAddress.setOpaque(false);
            this.lb_serverAddress.setToolTipText("Specify what server the Iperf client should connect to   (command line: -c)");
            this.serverAddress = new JTextField(15);
            this.serverAddress.addKeyListener(this);
            this.lb_serverPort = new JLabel("Port");
            this.lb_serverPort.setOpaque(false);
            this.lb_serverPort.setToolTipText("Specify port   (command line: -p)");
            this.serverPort = new IntegerSpinner(1, Integer.MAX_VALUE, 5001);
            this.serverPort.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_serverAddress);
            formLayoutBuilder.addCompositeCell(this.serverAddress, this.lb_serverPort, this.serverPort);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addCell(new JLabel());
            formLayoutBuilder.addCell(new JLabel());
            this.lb_simultaneousConnectionsNumber = new JLabel("Parallel Streams");
            this.lb_simultaneousConnectionsNumber.setOpaque(false);
            this.lb_simultaneousConnectionsNumber.setToolTipText("The number of simultaneous connections to make to the server. Default is 1.   (command line: -P)");
            this.simultaneousConnectionsNumber = new IntegerSpinner(1, Integer.MAX_VALUE, 1);
            this.simultaneousConnectionsNumber.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_simultaneousConnectionsNumber);
            formLayoutBuilder.addCell(this.simultaneousConnectionsNumber);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addEmptyCell();
            this.serverModeRadioButton = new JRadioButton("Server");
            this.serverModeRadioButton.setOpaque(false);
            this.serverModeRadioButton.setActionCommand("server");
            this.serverModeRadioButton.addActionListener(this);
            this.serverModeRadioButton.setToolTipText("Run Iperf as a server   (command line: -s)");
            formLayoutBuilder.addCell(this.serverModeRadioButton);
            this.lb_listenPort = new JLabel("Listen Port");
            this.lb_listenPort.setOpaque(false);
            this.lb_listenPort.setToolTipText("Specify listen port   (command line: -p)");
            this.listenPort = new IntegerSpinner(1, Integer.MAX_VALUE, 5001);
            this.listenPort.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_listenPort);
            this.lb_clientLimit = new JCheckBox("Client Limit");
            this.lb_clientLimit.addActionListener(this);
            this.lb_clientLimit.setOpaque(false);
            this.lb_clientLimit.setToolTipText("Specify a host for Iperf server to only accept connections from");
            this.clientLimit = new JTextField(15);
            this.clientLimit.addKeyListener(this);
            formLayoutBuilder.addCompositeCell(this.listenPort, this.lb_clientLimit, this.clientLimit);
            formLayoutBuilder.newLine();
            formLayoutBuilder.addEmptyCell();
            formLayoutBuilder.addEmptyCell();
            this.lb_connectionsLimitNumber = new JLabel("Num Connections");
            this.lb_connectionsLimitNumber.setOpaque(false);
            this.lb_connectionsLimitNumber.setToolTipText("The number of connections to handle by the server before closing. Default is 0 (handle forever)   (command line: -P)");
            formLayoutBuilder.addCell(this.lb_connectionsLimitNumber);
            this.connectionsLimitNumber = new IntegerSpinner(0, Integer.MAX_VALUE, 0);
            this.connectionsLimitNumber.addChangeListener(this);
            formLayoutBuilder.addCell(this.connectionsLimitNumber);
            formLayoutBuilder.newLine();
            this.iperfModeButtonGroup = new ButtonGroup();
            this.iperfModeButtonGroup.add(this.clientModeRadioButton);
            this.iperfModeButtonGroup.add(this.serverModeRadioButton);
            this.quickStartPanel = formLayoutBuilder.getPanel();
            this.quickStartPanel.setOpaque(false);
        }
        return this.quickStartPanel;
    }

    private JPanel getApplicationPanel() {
        if (this.applicationPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(3);
            this.compatibilityMode = new JCheckBox("Enable Compatibility Mode");
            formLayoutBuilder.addCell(this.compatibilityMode, 3);
            this.compatibilityMode.setToolTipText("Compatibility mode allows for use with older version of iperf   (command line: -C)");
            this.compatibilityMode.setSelected(false);
            if ((double)this.iperfVersion < 1.7) {
                this.compatibilityMode.setEnabled(false);
            }
            this.compatibilityMode.addActionListener(this);
            formLayoutBuilder.newLine();
            this.lb_transmit = new JLabel("Transmit");
            this.lb_transmit.setToolTipText("Time to transmit, or number of buffers to transmit. Default is 10secs   (command line: -t, -n)");
            this.transmit = new IntegerSpinner(0, Integer.MAX_VALUE, 10);
            this.transmit.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_transmit);
            formLayoutBuilder.addCell(this.transmit);
            formLayoutBuilder.newLine();
            this.transmitBytesRadioButton = new JRadioButton("Bytes");
            this.transmitBytesRadioButton.addActionListener(this);
            this.transmitSecondsRadioButton = new JRadioButton("Seconds");
            this.transmitSecondsRadioButton.addActionListener(this);
            formLayoutBuilder.addEmptyCell();
            formLayoutBuilder.addCompositeCell(this.transmitBytesRadioButton, this.transmitSecondsRadioButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.transmitSecondsRadioButton.setSelected(true);
            buttonGroup.add(this.transmitSecondsRadioButton);
            buttonGroup.add(this.transmitBytesRadioButton);
            formLayoutBuilder.newLine();
            this.lb_outputFormat = new JLabel("Output Format");
            this.lb_outputFormat.setToolTipText("Format to print bandwidth numbers in. Adaptive formats choose between kilo- and mega-   (command line: -f)");
            this.formatList = new JComboBox<IperfUnit>(IperfUnit.getAllowedOutputFormatUnits());
            this.formatList.addActionListener(this);
            this.formatList.setSelectedItem((Object)IperfUnit.KBITS);
            formLayoutBuilder.addCell(this.lb_outputFormat);
            formLayoutBuilder.addCell(this.formatList);
            formLayoutBuilder.newLine();
            this.lb_reportInterval = new JLabel("Report Interval");
            this.lb_reportInterval.setToolTipText("Sets the interval time (secs) between periodic bandwidth, jitter, and loss reports   (command line: -i)");
            this.interval = new IntegerSpinner(1, Integer.MAX_VALUE, 1);
            this.interval.addChangeListener(this);
            formLayoutBuilder.addCell(this.lb_reportInterval);
            formLayoutBuilder.addCompositeCell(this.interval, new JLabel("seconds"));
            formLayoutBuilder.newLine();
            this.lb_testingMode = new JLabel("Testing Mode");
            formLayoutBuilder.addCell(this.lb_testingMode);
            this.dualMode = new JCheckBox("Dual");
            this.dualMode.addActionListener(this);
            this.dualMode.setToolTipText("Cause the server to connect back to the client immediately and run tests simultaneously   (command line: -d)");
            this.tradeMode = new JCheckBox("Trade");
            this.tradeMode.addActionListener(this);
            this.tradeMode.setToolTipText("Cause the server to connect back to the client following termination of the client   (command line: -r)");
            formLayoutBuilder.addCompositeCell(this.dualMode, this.tradeMode);
            formLayoutBuilder.newLine();
            this.lb_testPort = new JLabel("test port");
            this.lb_testPort.setToolTipText("This specifies the port that the server will connect back to the client on   (command line: -L)");
            this.testPort = new IntegerSpinner(1, Integer.MAX_VALUE, 5001);
            this.testPort.addChangeListener(this);
            formLayoutBuilder.addEmptyCell();
            formLayoutBuilder.addCompositeCell(this.lb_testPort, this.testPort);
            if ((double)this.iperfVersion < 1.7) {
                this.lb_testingMode.setEnabled(false);
                this.dualMode.setEnabled(false);
                this.tradeMode.setEnabled(false);
                this.lb_testPort.setEnabled(false);
                this.testPort.setEnabled(false);
            }
            formLayoutBuilder.newLine();
            this.lb_representativeFile = new JLabel("Representative File");
            this.lb_representativeFile.setToolTipText("Use a representative stream to measure bandwidth   (command line: -F)");
            formLayoutBuilder.addCell(this.lb_representativeFile);
            this.representativeFile = new JTextField(14);
            this.representativeFile.addKeyListener(this);
            this.browse = new JButton("...");
            this.browse.setPreferredSize(new Dimension(35, 20));
            this.browse.setActionCommand("Browse");
            this.browse.addActionListener(this);
            formLayoutBuilder.addCompositeCell(this.representativeFile, this.browse);
            if ((double)this.iperfVersion < 1.2) {
                this.representativeFile.setEnabled(false);
                this.lb_representativeFile.setEnabled(false);
                this.browse.setEnabled(false);
            }
            formLayoutBuilder.newLine();
            this.printMSS = new JCheckBox("Print MSS");
            this.printMSS.addActionListener(this);
            this.printMSS.setToolTipText("Print out TCP maximum segment size   (command line: -m)");
            this.printMSS.setSelected(false);
            formLayoutBuilder.addCell(this.printMSS);
            formLayoutBuilder.newLine();
            this.applicationPanel = formLayoutBuilder.getPanel();
        }
        return this.applicationPanel;
    }

    private JPanel getTransportPanel() {
        if (this.transportPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(1, new FormLayoutColumn(FormLayoutBuilder.Alignment.fill));
            formLayoutBuilder.addCell(new JLabel("Choose the protocol to use"));
            formLayoutBuilder.newLine();
            this.tcpRadioButton = new JRadioButton("TCP");
            this.tcpRadioButton.setSelected(true);
            this.tcpRadioButton.setActionCommand("TCP");
            this.tcpRadioButton.addActionListener(this);
            this.tcpRadioButton.setToolTipText("Use TCP Protocol   (command line: default)");
            formLayoutBuilder.addCell(this.getTCPPanel());
            formLayoutBuilder.newLine();
            this.udpRadioButton = new JRadioButton("UDP");
            this.udpRadioButton.setActionCommand("UDP");
            this.udpRadioButton.addActionListener(this);
            this.udpRadioButton.setToolTipText("Use UDP Protocol   (command line: -u)");
            formLayoutBuilder.addCell(this.getUDPPanel());
            formLayoutBuilder.newLine();
            this.protocolButtonGroup = new ButtonGroup();
            this.protocolButtonGroup.add(this.tcpRadioButton);
            this.protocolButtonGroup.add(this.udpRadioButton);
            this.transportPanel = formLayoutBuilder.getPanel();
        }
        return this.transportPanel;
    }

    private void setTCPOptionsEnabled(boolean bl) {
        this.lb_tcpBufferLength.setEnabled(bl);
        this.tcpBufferLength.setEnabled(bl && this.lb_tcpBufferLength.isSelected());
        this.tcpBufferSizeUnit.setEnabled(bl && this.lb_tcpBufferLength.isSelected());
        this.lb_tcpWindowSize.setEnabled(bl);
        this.tcpWindowSize.setEnabled(bl && this.lb_tcpWindowSize.isSelected());
        this.tcpWindowSizeUnit.setEnabled(bl && this.lb_tcpWindowSize.isSelected());
        this.lb_mss.setEnabled(bl);
        this.mss.setEnabled(bl && this.lb_mss.isSelected());
        this.mssUnit.setEnabled(bl && this.lb_mss.isSelected());
        this.tcpNoDelay.setEnabled(bl);
        this.printMSS.setEnabled(bl);
        this.lb_TTL.setEnabled(!bl);
        this.TTL.setEnabled(!bl);
    }

    private JPanel getTCPPanel() {
        if (this.tcpPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(3, new FormLayoutColumn(FormLayoutBuilder.Alignment.fill));
            formLayoutBuilder.addCell(this.tcpRadioButton);
            formLayoutBuilder.newLine();
            this.lb_tcpBufferLength = new JCheckBox("Buffer Length");
            this.lb_tcpBufferLength.setToolTipText("Read/Write buffer length. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -l)");
            this.lb_tcpBufferLength.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_tcpBufferLength);
            this.tcpBufferLength = new DoubleSpinner(1.0, 9999.0, 8.0);
            this.tcpBufferLength.addChangeListener(this);
            formLayoutBuilder.addCell(this.tcpBufferLength);
            this.tcpBufferSizeUnit = new JComboBox<IperfUnit>(IperfUnit.getAllowedBufferSizeUnits());
            this.tcpBufferSizeUnit.addActionListener(this);
            this.tcpBufferSizeUnit.setSelectedItem((Object)IperfUnit.KBYTES);
            formLayoutBuilder.addCell(this.tcpBufferSizeUnit);
            formLayoutBuilder.newLine();
            this.lb_tcpWindowSize = new JCheckBox("TCP Window Size");
            this.lb_tcpWindowSize.setToolTipText("Set TCP window size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -w)");
            this.lb_tcpWindowSize.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_tcpWindowSize);
            this.tcpWindowSize = new DoubleSpinner(1.0, 9999.0, 8.0);
            this.tcpWindowSize.addChangeListener(this);
            formLayoutBuilder.addCell(this.tcpWindowSize);
            this.tcpWindowSizeUnit = new JComboBox<IperfUnit>(IperfUnit.getAllowedTCPWindowSizeUnits());
            this.tcpWindowSizeUnit.addActionListener(this);
            this.tcpWindowSizeUnit.setSelectedItem((Object)IperfUnit.KBYTES);
            formLayoutBuilder.addCell(this.tcpWindowSizeUnit);
            formLayoutBuilder.newLine();
            this.lb_mss = new JCheckBox("Max Segment Size");
            this.lb_mss.setToolTipText("Attempt to set max segment size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -M)");
            this.lb_mss.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_mss);
            this.mss = new DoubleSpinner(1.0, 9999.0, 8.0);
            this.mss.addChangeListener(this);
            formLayoutBuilder.addCell(this.mss);
            this.mssUnit = new JComboBox<IperfUnit>(IperfUnit.getAllowedTCPMaxSegmentSizeUnits());
            this.mssUnit.addActionListener(this);
            this.mssUnit.setSelectedItem((Object)IperfUnit.KBYTES);
            formLayoutBuilder.addCell(this.mssUnit);
            formLayoutBuilder.newLine();
            this.tcpNoDelay = new JCheckBox("TCP No Delay");
            this.tcpNoDelay.addActionListener(this);
            this.tcpNoDelay.setToolTipText("Disable Nagle's algorithm   (command line: -N)");
            this.tcpNoDelay.setSelected(false);
            formLayoutBuilder.addCell(this.tcpNoDelay);
            formLayoutBuilder.newLine();
            this.tcpPanel = formLayoutBuilder.getPanel();
            this.tcpPanel.setBorder(new TitledBorder(""));
        }
        return this.tcpPanel;
    }

    private void setUDPOptionsEnabled(boolean bl) {
        this.lb_udpBufferSize.setEnabled(bl);
        this.udpBufferSize.setEnabled(bl && this.lb_udpBufferSize.isSelected());
        this.udpBufferSizeUnit.setEnabled(bl && this.lb_udpBufferSize.isSelected());
        this.lb_udpPacketSize.setEnabled(bl);
        this.udpPacketSize.setEnabled(bl && this.lb_udpPacketSize.isSelected());
        this.udpPacketSizeUnit.setEnabled(bl && this.lb_udpPacketSize.isSelected());
        this.lb_udpBandwidth.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.udpBandwidth.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.udpBandwidthUnit.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.lb_TTL.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
        this.TTL.setEnabled(!this.serverModeRadioButton.isSelected() && bl);
    }

    private JPanel getUDPPanel() {
        if (this.udpPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(3, new FormLayoutColumn(FormLayoutBuilder.Alignment.fill));
            formLayoutBuilder.addCell(this.udpRadioButton);
            formLayoutBuilder.newLine();
            this.lb_udpBandwidth = new JLabel("UDP Bandwidth");
            this.lb_udpBandwidth.setToolTipText("Set bandwidth to send in bits/sec. Use 'K' or 'M' for kilo/mega bits. (i.e 8K)   (command line: -b)");
            formLayoutBuilder.addCell(this.lb_udpBandwidth);
            this.udpBandwidth = new DoubleSpinner(1.0, 9999.0, 1.0);
            this.udpBandwidth.addChangeListener(this);
            formLayoutBuilder.addCell(this.udpBandwidth);
            this.udpBandwidthUnit = new JComboBox<IperfSpeedUnit>(IperfSpeedUnit.values());
            this.udpBandwidthUnit.addActionListener(this);
            this.udpBandwidthUnit.setSelectedItem((Object)IperfSpeedUnit.MEGABYTES_PERSEC);
            formLayoutBuilder.addCell(this.udpBandwidthUnit);
            formLayoutBuilder.newLine();
            this.lb_udpBufferSize = new JCheckBox("UDP Buffer Size");
            this.lb_udpBufferSize.setToolTipText("Set UDP buffer size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -w)");
            this.lb_udpBufferSize.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_udpBufferSize);
            this.udpBufferSize = new DoubleSpinner(1.0, 9999.0, 8.0);
            this.udpBufferSize.addChangeListener(this);
            formLayoutBuilder.addCell(this.udpBufferSize);
            this.udpBufferSizeUnit = new JComboBox<IperfUnit>(IperfUnit.getAllowedBufferSizeUnits());
            this.udpBufferSizeUnit.addActionListener(this);
            this.udpBufferSizeUnit.setSelectedItem((Object)IperfUnit.KBYTES);
            formLayoutBuilder.addCell(this.udpBufferSizeUnit);
            formLayoutBuilder.newLine();
            this.lb_udpPacketSize = new JCheckBox("UDP Packet Size");
            this.lb_udpPacketSize.setToolTipText("Set UDP datagram buffer size. Use 'K' or 'M' for kilo/mega bytes. (i.e 1470)   (command line: -l)");
            this.lb_udpPacketSize.addActionListener(this);
            formLayoutBuilder.addCell(this.lb_udpPacketSize);
            this.udpPacketSize = new DoubleSpinner(1.0, 9999.0, 1500.0);
            this.udpPacketSize.addChangeListener(this);
            formLayoutBuilder.addCell(this.udpPacketSize);
            this.udpPacketSizeUnit = new JComboBox<IperfUnit>(IperfUnit.getAllowedUDPPacketSizeUnits());
            this.udpPacketSizeUnit.addActionListener(this);
            this.udpPacketSizeUnit.setSelectedItem((Object)IperfUnit.KBYTES);
            formLayoutBuilder.addCell(this.udpPacketSizeUnit);
            formLayoutBuilder.newLine();
            this.udpPanel = formLayoutBuilder.getPanel();
            this.udpPanel.setBorder(new TitledBorder(""));
        }
        return this.udpPanel;
    }

    private JPanel getIPPanel() {
        if (this.ipPanel == null) {
            FormLayoutBuilder formLayoutBuilder = new FormLayoutBuilder(2);
            this.lb_TTL = new JLabel("TTL");
            this.lb_TTL.setToolTipText("Set time to live (number of hops). Default is 1.   (command line: -T)");
            formLayoutBuilder.addCell(this.lb_TTL);
            this.TTL = new IntegerSpinner(0, Integer.MAX_VALUE, 1);
            this.TTL.addChangeListener(this);
            formLayoutBuilder.addCell(this.TTL);
            formLayoutBuilder.newLine();
            this.lb_tos = new JLabel("Type of Service");
            this.lb_tos.setToolTipText("The type-of-service for outgoing packets. (Many routers ignore the TOS field)   (command line: -S)");
            formLayoutBuilder.addCell(this.lb_tos);
            this.tos = new JComboBox<TosOption>(TosOption.values());
            this.tos.addActionListener(this);
            this.tos.setSelectedItem((Object)TosOption.NONE);
            formLayoutBuilder.addCell(this.tos);
            formLayoutBuilder.newLine();
            this.lb_bindHost = new JLabel("Bind to Host");
            this.lb_bindHost.setToolTipText("Bind to host, one of this machine's addresses. For multihomed hosts.   (command line: -B)");
            formLayoutBuilder.addCell(this.lb_bindHost);
            this.bindhost = new JTextField(18);
            this.bindhost.addKeyListener(this);
            formLayoutBuilder.addCell(this.bindhost);
            formLayoutBuilder.newLine();
            this.ipv6 = new JCheckBox("IPv6");
            formLayoutBuilder.addCell(this.ipv6);
            this.ipv6.setToolTipText("Bind to an IPv6 address   (command line: -V)");
            this.ipv6.setSelected(false);
            if ((double)this.iperfVersion < 1.6) {
                this.ipv6.setEnabled(false);
            }
            this.ipv6.addActionListener(this);
            formLayoutBuilder.newLine();
            this.ipPanel = formLayoutBuilder.getPanel();
        }
        return this.ipPanel;
    }

    public void init() {
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.setFileFilter((FileFilter)new ExtensionFileFilter("JPerf files", ".jperf"));
        this.loadFileChooser = new JFileChooser();
        this.loadFileChooser.setFileFilter((FileFilter)new ExtensionFileFilter("JPerf files", ".jperf"));
        this.menuBar = new JMenuBar();
        this.menuJPerf = new JMenu("JPerf");
        this.menuJPerf.setMnemonic(72);
        this.menuJPerfOpen = new JMenuItem("Open configuration...");
        this.menuJPerfOpen.setActionCommand("LoadConfiguration");
        this.menuJPerfOpen.addActionListener(this);
        this.menuJPerf.add(this.menuJPerfOpen);
        this.menuJPerfSaveAs = new JMenuItem("Save configuration as...");
        this.menuJPerfSaveAs.setActionCommand("SaveConfiguration");
        this.menuJPerfSaveAs.addActionListener(this);
        this.menuJPerf.add(this.menuJPerfSaveAs);
        this.menuJPerfRestoreDefaults = new JMenuItem("Restore default configuration");
        this.menuJPerfRestoreDefaults.setActionCommand("Restore");
        this.menuJPerfRestoreDefaults.addActionListener(this);
        this.menuJPerf.add(this.menuJPerfRestoreDefaults);
        this.menuJPerf.addSeparator();
        this.menuJPerfAbout = new JMenuItem("About...");
        this.menuJPerfAbout.setActionCommand("About");
        this.menuJPerfAbout.addActionListener(this);
        this.menuJPerf.add(this.menuJPerfAbout);
        this.menuJPerf.addSeparator();
        this.menuJPerfQuit = new JMenuItem("Quit");
        this.menuJPerfQuit.setActionCommand("Quit");
        this.menuJPerfQuit.addActionListener(this);
        this.menuJPerf.add(this.menuJPerfQuit);
        this.menuBar.add(this.menuJPerf);
        this.setJMenuBar(this.menuBar);
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.getQuickStartPanel());
        this.startIperf = new JButton(new ImageIcon(JPerfUI.class.getResource("start.png")));
        this.startIperf.setToolTipText("Run IPerf!");
        this.startIperf.setText("Run IPerf!");
        this.startIperf.setActionCommand("Run");
        this.startIperf.addActionListener(this);
        this.stopIperf = new JButton(new ImageIcon(JPerfUI.class.getResource("logout.png")));
        this.stopIperf.setToolTipText("Stop Iperf");
        this.stopIperf.setText("Stop IPerf!");
        this.stopIperf.setActionCommand("Stop");
        this.stopIperf.addActionListener(this);
        this.stopIperf.setEnabled(false);
        this.saveConfiguration = new JButton(new ImageIcon(JPerfUI.class.getResource("filesaveas.png")));
        this.saveConfiguration.setToolTipText("Save configuration");
        this.saveConfiguration.setActionCommand("SaveConfiguration");
        this.saveConfiguration.addActionListener(this);
        this.loadConfiguration = new JButton(new ImageIcon(JPerfUI.class.getResource("fileopen.png")));
        this.loadConfiguration.setToolTipText("Load configuration");
        this.loadConfiguration.setActionCommand("LoadConfiguration");
        this.loadConfiguration.addActionListener(this);
        this.restoreDefaults = new JButton(new ImageIcon(JPerfUI.class.getResource("reload.png")));
        this.restoreDefaults.setToolTipText("Restore default settings");
        this.restoreDefaults.setActionCommand("Restore");
        this.restoreDefaults.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        jPanel.add(this.saveConfiguration);
        jPanel.add(this.loadConfiguration);
        jPanel.add(this.restoreDefaults);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.add(this.startIperf);
        jPanel2.add(this.stopIperf);
        jPanel2.add(jPanel);
        this.toolbar.add(jPanel2);
        this.add((Component)this.toolbar, "First");
        JXTaskPaneContainer jXTaskPaneContainer = new JXTaskPaneContainer();
        JXTaskPane jXTaskPane = new JXTaskPane();
        jXTaskPane.setAnimated(true);
        jXTaskPane.setTitle("Application layer options");
        jXTaskPane.add((Component)this.getApplicationPanel());
        JXTaskPane jXTaskPane2 = new JXTaskPane();
        jXTaskPane2.setAnimated(true);
        jXTaskPane2.setTitle("Transport layer options");
        jXTaskPane2.add((Component)this.getTransportPanel());
        JXTaskPane jXTaskPane3 = new JXTaskPane();
        jXTaskPane3.setAnimated(true);
        jXTaskPane3.setTitle("IP layer options");
        jXTaskPane3.add((Component)this.getIPPanel());
        jXTaskPaneContainer.add(jXTaskPane);
        jXTaskPaneContainer.add(jXTaskPane2);
        jXTaskPaneContainer.add(jXTaskPane3);
        jXTaskPaneContainer.setScrollableTracksViewportHeight(true);
        jXTaskPaneContainer.setScrollableTracksViewportWidth(true);
        JScrollPane jScrollPane = new JScrollPane((Component)jXTaskPaneContainer);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)jScrollPane, "West");
        this.centerPanel = new JSplitPane(0);
        this.centerPanel.setLeftComponent(this.getGraphPanel());
        this.centerPanel.setRightComponent(this.getOutputPanel());
        this.centerPanel.setDividerLocation(300);
        this.centerPanel.setResizeWeight(1.0);
        this.centerPanel.setOneTouchExpandable(true);
        this.add((Component)this.centerPanel, "Center");
        this.createAbout();
    }

    public void logMessage(String string) {
        this.output.append(string + "\n");
        this.output.setCaretPosition(this.output.getDocument().getLength());
    }

    public void addNewStreamBandwidthMeasurement(int n, Measurement measurement) {
        this.chartPanel.maybeAddNewSeries("" + n, "#" + n + ": ", "Jitter: ", SeriesColorGenerator.nextColor());
        this.chartPanel.addSeriesBandwidthMeasurement("" + n, measurement);
    }

    public void addNewStreamBandwidthAndJitterMeasurement(int n, Measurement measurement, Measurement measurement2) {
        this.chartPanel.maybeAddNewSeries("" + n, "#" + n + ": ", "Jitter: ", SeriesColorGenerator.nextColor());
        this.chartPanel.addSeriesBandwidthAndJitterMeasurement("" + n, measurement, measurement2);
    }

    public void setStartedStatus() {
        this.startIperf.setEnabled(false);
        this.stopIperf.setEnabled(true);
    }

    public void setStoppedStatus() {
        this.stopIperf.setEnabled(false);
        this.startIperf.setEnabled(true);
    }

    private JPanel getGraphPanel() {
        if (this.chartPanel == null) {
            this.chartPanel = new IPerfChartPanel("Bandwidth", "KBits", "ms", "Time", "Bandwidth", "Jitter", 1.0, 20.0, 1.0, Color.black, Color.white, Color.gray);
        }
        return this.chartPanel;
    }

    private JPanel getOutputPanel() {
        if (this.outputPanel == null) {
            this.outputPanel = new JPanel(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.output = new JTextArea();
            this.output.setWrapStyleWord(false);
            this.outputScrollPane = new JScrollPane(this.output);
            this.tabbedPane.addTab("Output", null, this.outputScrollPane, "Iperf Output");
            this.outputPanel.add((Component)this.tabbedPane, "Center");
            JPanel jPanel = new JPanel(new FlowLayout(1));
            this.clearOutputButton = new JButton("Clear now");
            this.clearOutputButton.setActionCommand("Clear");
            this.clearOutputButton.addActionListener(this);
            this.clearOutputButton.setToolTipText("Clears output from Iperf run");
            this.saveOutputButton = new JButton("Save");
            this.saveOutputButton.setActionCommand("Save");
            this.saveOutputButton.addActionListener(this);
            this.saveOutputButton.setToolTipText("Save output to a file");
            this.alwaysClearOutput = new JCheckBox("Clear Output on each Iperf Run");
            this.alwaysClearOutput.setToolTipText("Always clear Iperf output between runs.");
            this.alwaysClearOutput.setSelected(false);
            jPanel.add(this.saveOutputButton);
            jPanel.add(this.clearOutputButton);
            jPanel.add(this.alwaysClearOutput);
            this.outputPanel.add((Component)jPanel, "South");
        }
        return this.outputPanel;
    }

    public void updateIperfCommandLabel() {
        try {
            this.validateFormOptions();
            this.iperfCommandLabel.setForeground(Color.black);
            this.iperfCommandLabel.setText(this.options);
        }
        catch (Exception exception) {
            this.iperfCommandLabel.setForeground(Color.red);
            this.iperfCommandLabel.setText(exception.getMessage());
        }
    }

    private void _compatibilityMode_actionPerformed() {
        if (this.compatibilityMode.isSelected()) {
            this.lb_testingMode.setEnabled(false);
            this.dualMode.setEnabled(false);
            this.tradeMode.setEnabled(false);
            this.lb_testPort.setEnabled(false);
            this.testPort.setEnabled(false);
        } else if (!this.serverModeRadioButton.isSelected()) {
            this.lb_testingMode.setEnabled(true);
            this.dualMode.setEnabled(true);
            this.tradeMode.setEnabled(true);
            this.lb_testPort.setEnabled(true);
            this.testPort.setEnabled(true);
        }
    }

    private void _lb_clientLimit_actionPerformed() {
    }

    private void _transmitBytesRadioButton_actionPerformed() {
    }

    private void _transmitSecondsRadioButton_actionPerformed() {
    }

    private void _dualMode_actionPerformed() {
    }

    private void _tradeMode_actionPerformed() {
    }

    private void _printMSS_actionPerformed() {
    }

    private void _lb_tcpBufferLength_actionPerformed() {
        this.tcpBufferLength.setEnabled(this.lb_tcpBufferLength.isSelected());
        this.tcpBufferSizeUnit.setEnabled(this.lb_tcpBufferLength.isSelected());
    }

    private void _lb_tcpWindowSize_actionPerformed() {
        this.tcpWindowSize.setEnabled(this.lb_tcpWindowSize.isSelected());
        this.tcpWindowSizeUnit.setEnabled(this.lb_tcpWindowSize.isSelected());
    }

    private void _lb_mss_actionPerformed() {
        this.mss.setEnabled(this.lb_mss.isSelected());
        this.mssUnit.setEnabled(this.lb_mss.isSelected());
    }

    private void _lb_udpBufferSize_actionPerformed() {
        this.udpBufferSize.setEnabled(this.lb_udpBufferSize.isSelected());
        this.udpBufferSizeUnit.setEnabled(this.lb_udpBufferSize.isSelected());
    }

    private void _lb_udpPacketSize_actionPerformed() {
        this.udpPacketSize.setEnabled(this.lb_udpPacketSize.isSelected());
        this.udpPacketSizeUnit.setEnabled(this.lb_udpPacketSize.isSelected());
    }

    private void _tcpNoDelay_actionPerformed() {
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object object = actionEvent.getSource();
                if (object == JPerfUI.this.ipv6) {
                    if (JPerfUI.this.ipv6.isSelected()) {
                        if (JPerfUI.this.udpRadioButton.isSelected()) {
                            JPerfUI.this.udpBufferSize.setValue(1450);
                        }
                    } else if (JPerfUI.this.udpRadioButton.isSelected()) {
                        JPerfUI.this.udpBufferSize.setValue(1470);
                    }
                } else if (object == JPerfUI.this.compatibilityMode) {
                    JPerfUI.this._compatibilityMode_actionPerformed();
                } else if (object == JPerfUI.this.lb_clientLimit) {
                    JPerfUI.this._lb_clientLimit_actionPerformed();
                } else if (object == JPerfUI.this.transmitBytesRadioButton) {
                    JPerfUI.this._transmitBytesRadioButton_actionPerformed();
                } else if (object == JPerfUI.this.transmitSecondsRadioButton) {
                    JPerfUI.this._transmitSecondsRadioButton_actionPerformed();
                } else if (object == JPerfUI.this.dualMode) {
                    JPerfUI.this._dualMode_actionPerformed();
                } else if (object == JPerfUI.this.tradeMode) {
                    JPerfUI.this._tradeMode_actionPerformed();
                } else if (object == JPerfUI.this.printMSS) {
                    JPerfUI.this._printMSS_actionPerformed();
                } else if (object == JPerfUI.this.lb_tcpBufferLength) {
                    JPerfUI.this._lb_tcpBufferLength_actionPerformed();
                } else if (object == JPerfUI.this.lb_tcpWindowSize) {
                    JPerfUI.this._lb_tcpWindowSize_actionPerformed();
                } else if (object == JPerfUI.this.lb_mss) {
                    JPerfUI.this._lb_mss_actionPerformed();
                } else if (object == JPerfUI.this.lb_udpBufferSize) {
                    JPerfUI.this._lb_udpBufferSize_actionPerformed();
                } else if (object == JPerfUI.this.lb_udpPacketSize) {
                    JPerfUI.this._lb_udpPacketSize_actionPerformed();
                } else if (object == JPerfUI.this.tcpNoDelay) {
                    JPerfUI.this._tcpNoDelay_actionPerformed();
                } else {
                    JFileChooser jFileChooser;
                    int n;
                    String string = actionEvent.getActionCommand();
                    if (string == "Restore") {
                        JPerfUI.this.applyConfiguration(JPerfUI.this.defaultConfiguration);
                    } else if (string == "SaveConfiguration") {
                        int n2 = JPerfUI.this.saveFileChooser.showSaveDialog(JPerfUI.this);
                        if (n2 == 0) {
                            File file = JPerfUI.this.saveFileChooser.getSelectedFile();
                            try {
                                IPerfProperties iPerfProperties = JPerfUI.this.getCurrentConfiguration();
                                if (!file.getName().endsWith(".jperf")) {
                                    file = new File(file.getAbsolutePath() + ".jperf");
                                }
                                iPerfProperties.saveAs(file);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                JOptionPane.showMessageDialog(JPerfUI.this, "<html>Impossible to save this configuration.<br>(cause='" + exception.getMessage() + "')</html>", "Error", 0);
                            }
                        }
                    } else if (string == "LoadConfiguration") {
                        int n3 = JPerfUI.this.loadFileChooser.showOpenDialog(JPerfUI.this);
                        if (n3 == 0) {
                            File file = JPerfUI.this.loadFileChooser.getSelectedFile();
                            try {
                                JPerfUI.this.applyConfiguration(new IPerfProperties(file));
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(JPerfUI.this, "<html>Impossible to load this configuration file.<br>(cause='" + exception.getMessage() + "')</html>", "Error", 0);
                            }
                        }
                    } else if (string == "TCP") {
                        JPerfUI.this.setUDPOptionsEnabled(false);
                        JPerfUI.this.setTCPOptionsEnabled(true);
                    } else if (string == "UDP") {
                        JPerfUI.this.setTCPOptionsEnabled(false);
                        JPerfUI.this.setUDPOptionsEnabled(true);
                    } else if (string == "Run") {
                        boolean bl = false;
                        try {
                            bl = JPerfUI.this.validateFormOptions();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(JPerfUI.this, exception.getMessage(), "Error", 0);
                            return;
                        }
                        IperfUnit iperfUnit = (IperfUnit)((Object)JPerfUI.this.formatList.getSelectedItem());
                        if (iperfUnit == IperfUnit.ADAPTIVE_BITS || iperfUnit == IperfUnit.ADAPTIVE_BYTES) {
                            JOptionPane.showMessageDialog(JPerfUI.this, "The bandwidth graph will not be created because an adaptive format is selected", "Information", 1);
                        }
                        if (bl) {
                            JPerfUI.this.chartPanel.reconfigure(JPerfUI.this.serverModeRadioButton.isSelected(), JPerfUI.this.serverModeRadioButton.isSelected() ? "Bandwidth & Jitter" : "Bandwidth", JPerfUI.this.formatList.getSelectedItem().toString(), "ms", JPerfUI.this.transmitSecondsRadioButton.isSelected() ? "Time (sec)" : "Bytes transmitted", JPerfUI.this.formatList.getSelectedItem().toString() + " (BW)", "ms (Jitter)", JPerfUI.this.transmit.getValue().intValue(), JPerfUI.this.interval.getValue().intValue());
                            if (JPerfUI.this.alwaysClearOutput.isSelected()) {
                                JPerfUI.this.output.setText("");
                            }
                            JPerfUI.this.iperf = new IperfThread(JPerfUI.this.serverModeRadioButton.isSelected(), JPerfUI.this.options, JPerfUI.this);
                            JPerfUI.this.iperf.start();
                        }
                    } else if (string == "Stop") {
                        JPerfUI.this.iperf.quit();
                    } else if (string == "Clear") {
                        JPerfUI.this.iperf.quit();
                        JPerfUI.this.output.setText("");
                    } else if (string == "server") {
                        JPerfUI.this.setClientModeSelected(false);
                        JPerfUI.this.setServerModeSelected(true);
                    } else if (string == "client") {
                        JPerfUI.this.setServerModeSelected(false);
                        JPerfUI.this.setClientModeSelected(true);
                    } else if (string == "About") {
                        JOptionPane.showMessageDialog(JPerfUI.this, JPerfUI.this.aboutPanel);
                    } else if (string == "Quit") {
                        System.exit(0);
                    } else if (string == "Browse") {
                        JFileChooser jFileChooser2 = new JFileChooser();
                        int n4 = jFileChooser2.showDialog(JPerfUI.this, "Select representative file");
                        if (n4 == 0) {
                            File file = jFileChooser2.getSelectedFile();
                            JPerfUI.this.representativeFile.setText(file.getAbsolutePath());
                        }
                    } else if (string == "Save" && (n = (jFileChooser = new JFileChooser()).showDialog(JPerfUI.this, "Save")) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        String string2 = new String(JPerfUI.this.output.getText());
                        try {
                            FileWriter fileWriter = new FileWriter(file);
                            fileWriter.write(string2);
                            fileWriter.close();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(JPerfUI.this, "Error while saving output: " + iOException.getMessage(), "Error", 0);
                        }
                    }
                }
                JPerfUI.this.updateIperfCommandLabel();
            }
        });
    }

    private boolean validateFormOptions() throws Exception {
        this.options = this.iperfCommand;
        if (this.serverModeRadioButton.isSelected()) {
            this.options = this.options + " -s";
            if (this.clientLimit.getText().length() > 0 && this.lb_clientLimit.isSelected()) {
                this.options = this.options + " -c " + this.clientLimit.getText();
            }
        } else if (this.serverAddress.getText().length() > 0) {
            this.options = this.options + " -c " + this.serverAddress.getText();
        } else {
            this.serverAddress.grabFocus();
            throw new Exception("Please enter the host to connect to");
        }
        if (this.udpRadioButton.isSelected()) {
            this.options = this.options + " -u";
        }
        if (this.simultaneousConnectionsNumber.isEnabled()) {
            this.options = this.options + " -P " + this.simultaneousConnectionsNumber.getValue();
        } else if (this.connectionsLimitNumber.isEnabled()) {
            this.options = this.options + " -P " + this.connectionsLimitNumber.getValue();
        }
        this.options = this.options + " -i " + this.interval.getValue();
        if (this.printMSS.isSelected() && this.printMSS.isEnabled()) {
            this.options = this.options + " -m";
        }
        if (this.serverPort.isEnabled()) {
            this.options = this.options + " -p " + this.serverPort.getValue();
        } else if (this.listenPort.isEnabled()) {
            this.options = this.options + " -p " + this.listenPort.getValue();
        }
        if (this.lb_tcpWindowSize.isSelected() && this.tcpWindowSize.isEnabled()) {
            this.options = this.options + " -w " + this.tcpWindowSize.getValue() + ((IperfUnit)((Object)this.tcpWindowSizeUnit.getSelectedItem())).getShortcut();
        } else if (this.lb_udpBufferSize.isSelected() && this.udpBufferSize.isEnabled()) {
            this.options = this.options + " -w " + this.udpBufferSize.getValue() + ((IperfUnit)((Object)this.udpBufferSizeUnit.getSelectedItem())).getShortcut();
        }
        if (this.bindhost.getText().length() > 0) {
            this.options = this.options + " -B " + this.bindhost.getText();
        }
        if (this.lb_mss.isSelected() && this.mss.isEnabled()) {
            this.options = this.options + " -M " + this.mss.getValue() + ((IperfUnit)((Object)this.mssUnit.getSelectedItem())).getShortcut();
        }
        if (this.tcpNoDelay.isSelected() && this.tcpNoDelay.isEnabled()) {
            this.options = this.options + " -N";
        }
        if (this.ipv6.isSelected() && this.ipv6.isEnabled()) {
            this.options = this.options + " -V";
        }
        if (this.lb_tcpBufferLength.isSelected() && this.tcpBufferLength.isEnabled()) {
            this.options = this.options + " -l " + this.tcpBufferLength.getValue() + ((IperfUnit)((Object)this.tcpBufferSizeUnit.getSelectedItem())).getShortcut();
        } else if (this.lb_udpPacketSize.isSelected() && this.udpPacketSize.isEnabled()) {
            this.options = this.options + " -l " + this.udpPacketSize.getValue() + ((IperfUnit)((Object)this.udpPacketSizeUnit.getSelectedItem())).getShortcut();
        }
        if (this.compatibilityMode.isSelected() && this.compatibilityMode.isEnabled()) {
            this.options = this.options + " -C";
        }
        this.options = this.options + " -f " + ((IperfUnit)((Object)this.formatList.getSelectedItem())).getShortcut();
        if (this.udpBandwidthUnit.isEnabled() && this.udpBandwidth.isEnabled()) {
            this.options = this.options + " -b " + this.udpBandwidth.getValue() + ((IperfSpeedUnit)((Object)this.udpBandwidthUnit.getSelectedItem())).getUnit();
        }
        if (this.transmit.isEnabled()) {
            if (this.transmitBytesRadioButton.isSelected()) {
                this.options = this.options + " -n " + this.transmit.getValue();
            } else if (this.transmitSecondsRadioButton.isSelected()) {
                this.options = this.options + " -t " + this.transmit.getValue();
            }
        }
        if (this.dualMode.isSelected() && this.dualMode.isEnabled()) {
            this.options = this.options + " -d";
        }
        if (this.tradeMode.isSelected() && this.tradeMode.isEnabled()) {
            this.options = this.options + " -r";
        }
        if ((this.dualMode.isSelected() && this.dualMode.isEnabled() || this.tradeMode.isSelected() && this.tradeMode.isEnabled()) && this.testPort.isEnabled()) {
            this.options = this.options + " -L " + this.testPort.getValue();
        }
        if (this.TTL.isEnabled()) {
            this.options = this.options + " -T " + this.TTL.getValue();
        }
        if ((TosOption)((Object)this.tos.getSelectedItem()) != TosOption.NONE) {
            this.options = this.options + " -S " + ((TosOption)((Object)this.tos.getSelectedItem())).getCode();
        }
        if (this.representativeFile.getText().length() > 0 && this.representativeFile.isEnabled()) {
            File file = new File(this.representativeFile.getText());
            if (!file.exists()) {
                this.representativeFile.grabFocus();
                throw new Exception("The file you selected does not exist");
            }
            this.options = this.options + " -F " + this.representativeFile.getText();
        }
        return true;
    }

    private void createAbout() {
        this.aboutPanel = new JPerfAboutPanel(this.version);
        this.aboutPanel.setPreferredSize(new Dimension(450, 350));
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.updateIperfCommandLabel();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateIperfCommandLabel();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.stopIperf.doClick();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

