#!/bin/sh

#ETHDEVICE=$2
#IFCONFIG=`ifconfig $ETHDEVICE 2>/dev/null`
#RX=`echo $IFCONFIG | sed -n 's_.*RX bytes:\([0-9]\+\) .*_\1_p'`
#TX=`echo $IFCONFIG | sed -n 's_.*TX bytes:\([0-9]\+\) .*_\1_p'`

bytestohuman() {
    # converts a byte count to a human readable format in IEC binary notation (base-1024), rounded to two decimal places for anything larger than a byte. switchable to padded format and base-1000 if desired.
    local L_BYTES="${1:-0}"
    local L_PAD="${2:-no}"
    local L_BASE="${3:-1024}"
    BYTESTOHUMAN_RESULT=$(awk -v bytes="${L_BYTES}" -v pad="${L_PAD}" -v base="${L_BASE}" 'function human(x, pad, base) {
         if(base!=1024)base=1000
         basesuf=(base==1024)?"iB":"B"

         s="BKMGTEPYZ"
         while (x>=base && length(s)>1)
               {x/=base; s=substr(s,2)}
         s=substr(s,1,1)

         xf=(pad=="yes") ? ((s=="B")?"%5d   ":"%8.2f") : ((s=="B")?"%d":"%.2f")
         s=(s!="B") ? (s basesuf) : ((pad=="no") ? s : ((basesuf=="iB")?(s "  "):(s " ")))

         return sprintf( (xf " %s\n"), x, s)
      }
      BEGIN{print human(bytes, pad, base)}')
    return $?
}

abs() {
	ABS=$(echo $1 | awk '{y=($1<0?-$1:$1);print y}')
	echo $ABS
}


IFACE=$(awk '$2 == 00000000 { print $1 }' /proc/net/route)

if [ "${IFACE:-eth1}" != "eth0.2" ]; then
# Read Current Values
RX1=$(cat /sys/class/net/$IFACE/statistics/rx_bytes)
TX1=$(cat /sys/class/net/$IFACE/statistics/tx_bytes)
TOTAL1="$(($RX1+$TX1))"

# Read Stored Values
RXS=$(uci get -q bwinternal.internet.last_rx)
TXS=$(uci get -q bwinternal.internet.last_tx)
TOTS=$(uci get -q bwinternal.internet.last_total)
[ -z "$RXS" ] && RXS=0
[ -z "$TXS" ] && TXS=0
[ -z "$TOTS" ] && TOTS=0

# Do Diff between stored and read
TDIFF=`expr $TX1 - $TXS`
RDIFF=`expr $RX1 - $RXS`
TOT=`expr $TOTAL1 - $TOTS`
if [ "$TDIFF" -lt 0 ]
then
	# interface counter is reset
	ABS_TDIFF=`abs $TX1`
else
	ABS_TDIFF=`abs $TDIFF`
fi
if [ "$RDIFF" -lt 0 ]
then
	# interface counter is reset
	ABS_RDIFF=`abs $RX1`
else
	ABS_RDIFF=`abs $RDIFF`
fi
if [ "$TOT" -lt 0 ]
then
	# interface counter is reset
	ABS_TOT=`abs $TOTAL1`
else
	ABS_TOT=`abs $TOT`
fi

uci set bwinternal.internet.last_tx="$TX1"
uci set bwinternal.internet.last_rx="$RX1"
uci set bwinternal.internet.last_total="$TOTAL1"

down=$(uci -q get bwinternal.internet.down)
up=$(uci -q get bwinternal.internet.up)
total=$(uci -q get bwinternal.internet.total)
[ -z "$down" ] && down=0
[ -z "$up" ] && up=0
[ -z "$total" ] && total=0

# ADD Diff to main TOTAL
TDIFF2=`expr $up + $ABS_TDIFF`
RDIFF2=`expr $down + $ABS_RDIFF`
TOT2=`expr $total + $ABS_TOT`

bytestohuman $RDIFF2 no 1000
uci set -q bwinternal.internet.down=$RDIFF2
uci set -q bwinternal.internet.readdown="${BYTESTOHUMAN_RESULT}"

bytestohuman $TDIFF2 no 1000
uci set -q bwinternal.internet.up=$TDIFF2
uci set -q bwinternal.internet.readup="${BYTESTOHUMAN_RESULT}"

bytestohuman $TOT2 no 1000
uci set -q bwinternal.internet.total=$TOT2
uci set -q bwinternal.internet.readtotal="${BYTESTOHUMAN_RESULT}"

uci commit bwinternal

fi

#-----------------------------------------------------------------------------
if [ -f "/sys/class/net/eth0.2/statistics/rx_bytes" ]; then
	# Read Current Values
	RX2=$(cat /sys/class/net/eth0.2/statistics/rx_bytes)
	TX2=$(cat /sys/class/net/eth0.2/statistics/tx_bytes)
	TOTAL2="$(($RX2+$TX2))"
	
	# Read Stored Values
	RXS2=$(uci get -q bwinternal.wan.last_rx)
	TXS2=$(uci get -q bwinternal.wan.last_tx)
	TOTS2=$(uci get -q bwinternal.wan.last_total)
	[ -z "$RXS2" ] && RXS2=0
	[ -z "$TXS2" ] && TXS2=0
	[ -z "$TOTS2" ] && TOTS2=0

	# Do Diff between stored and read
	TDIFF=`expr $TX2 - $TXS2`
	RDIFF=`expr $RX2 - $RXS2`
	TOT=`expr $TOTAL2 - $TOTS2`

	if [ "$TDIFF" -lt 0 ]
	then
		# interface counter is reset
		ABS_TDIFF=`abs $TX2`
	else
		ABS_TDIFF=`abs $TDIFF`
	fi
	if [ "$RDIFF" -lt 0 ]
	then
		# interface counter is reset
		ABS_RDIFF=`abs $RX2`
	else
		ABS_RDIFF=`abs $RDIFF`
	fi
	if [ "$TOT" -lt 0 ]
	then
		# interface counter is reset
		ABS_TOT=`abs $TOTAL2`
	else
		ABS_TOT=`abs $TOT`
	fi

	uci set bwinternal.wan.last_tx="$TX2"
	uci set bwinternal.wan.last_rx="$RX2"
	uci set bwinternal.wan.last_total="$TOTAL2"

	down=$(uci -q get bwinternal.wan.down)
	up=$(uci -q get bwinternal.wan.up)
	total=$(uci -q get bwinternal.wan.total)
	[ -z "$down" ] && down=0
	[ -z "$up" ] && up=0
	[ -z "$total" ] && total=0


	# ADD Diff to main TOTAL
	TDIFF2=`expr $up + $ABS_TDIFF`
	RDIFF2=`expr $down + $ABS_RDIFF`
	TOT2=`expr $total + $ABS_TOT`

	bytestohuman $RDIFF2 no 1000
	uci set -q bwinternal.wan.down=$RDIFF2
	uci set -q bwinternal.wan.readdown="${BYTESTOHUMAN_RESULT}"

	bytestohuman $TDIFF2 no 1000
	uci set -q bwinternal.wan.up=$TDIFF2
	uci set -q bwinternal.wan.readup="${BYTESTOHUMAN_RESULT}"

	bytestohuman $TOT2 no 1000
	uci set -q bwinternal.wan.total=$TOT2
	uci set -q bwinternal.wan.readtotal="${BYTESTOHUMAN_RESULT}"

	uci commit bwinternal
fi
