module("luci.controller.admin.parental", package.seeall)

function index()
	local page

	entry({"admin", "parental"}, alias("admin", "parental", "bwcurrent"), _("Bandwidth Filters"), 90).index = true
	--entry({"quick", "parental", "bwcurrent"}, cbi("quick/bwcurrent", {autoapply=true}), _("Internet Usage"), 5)
	--entry({"admin", "parental", "bwcurrent"}, cbi("rooter/usage", {autoapply=true}), _("Internet Usage"), 5)
	--entry({"admin", "parental", "macfilter"}, cbi("rooter/macfilter", {autoapply=true}), _("Mac Filter"), 12)

	--entry({"admin", "parental", "shield"}, cbi("rooter/shield", {autoapply=true}), _("Mofi Family Shield"), 13)

	entry({"admin", "parental", "monitor"}, cbi("rooter/monitor", {autoapply=true}), _("Bandwidth Monitoring"), 13)
	--entry({"admin", "parental", "tracker"}, cbi("rooter/bandtracker", {autoapply=true}), _("Auto Limits"), 14)
	--entry({"admin", "parental", "opendns"}, cbi("rooter/opendns", {autoapply=true}), _("OpenDNS"), 15)

	--[[
	if nixio.fs.access("/usr/sbin/tc") then
		entry({"admin", "parental", "blimits"}, cbi("rooter/blimits", {autoapply=true}), _("Speed Limiter"), 25)
	end
	]]--
	entry({"admin", "parental", "get_user_limits"}, call("action_get_user_limits"))
	entry({"admin", "parental", "get_user"}, call("action_get_user"))
	entry({"admin", "parental", "get_user_tracker"}, call("action_get_user_tracker"))
	  --dawsen add
        entry({"admin", "parental", "ipdomainfilter"}, cbi("rooter/ipdomainfilter"), _("IP/Domain Filter"), 30)

end

function Split(str, delim, maxNb)
    -- Eliminate bad cases...
    if string.find(str, delim) == nil then
        return { str }
    end
    if maxNb == nil or maxNb < 1 then
        maxNb = 0    -- No limit
    end
    local result = {}
    local pat = "(.-)" .. delim .. "()"
    local nb = 0
    local lastPos
    for part, pos in string.gfind(str, pat) do
        nb = nb + 1
        result[nb] = part
        lastPos = pos
        if nb == maxNb then break end
    end
    -- Handle the last field
    if nb ~= maxNb then
        result[nb + 1] = string.sub(str, lastPos)
    end
    return result
end

function form(tem)
	temp = tonumber(tem)
	if temp < 1024 then
		tstr = string.format("%g", temp)
		ufm = "KB"
	else
		if temp < 1048576 then
			tstr = string.format("%g", temp/1024)
			ufm = "MB"
		else
			tstr = string.format("%g", temp/1048576)
			ufm = "GB"
		end
	end
	local str = tstr .. " " .. ufm
	return str
end

function action_get_user_limits()
	local rv = {}

	local num = 0
	local ip = nil
	local mac = nil
	local download = nil
	local total = nil
	local str = ""
	local file = io.open("/tmp/busage.db", "r")
	if file ~= nil then
		repeat
			local line = file:read("*line")
			if line == nil then
				break
			end
			num = num + 1
			local t = Split(line, ",", 7)
			local pi = t[7]
			local host = nixio.getnameinfo(pi)
			local per, pere
			if host == nil then
				host = pi
			else
				per, pere = string.find(host, ".lan")
				local tt = host
				if per ~= nil then
					tt = string.sub(host, 1, per-1) 
					--tt = host
				end
				host = pi .. " ( " .. tt .. " )"
			end
			if ip ~= nil then
				ip = ip .. "$$" .. host
			else
				ip = host
			end
			if mac ~= nil then
				mac = mac .. "$$" .. t[1]
			else
				mac = t[1]
			end

			local temp = t[2]
			str = form(temp)
			if download ~= nil then
				download = download .. "$$" .. str
			else
				download = str
			end
			local temp = t[3]
			str = form(temp)
			if upload ~= nil then
				upload = upload .. "$$" .. str
			else
				upload = str
			end
			local tot = t[2] + t[3]
			str = form(tot)
			if total ~= nil then
				total = total .. "$$" .. str
			else
				total = str
			end
		until 1 == 0
		file:close()
	end

	rv["length"] = num
	rv["ip"] = ip
	rv["mac"] = mac
	rv["up"] = upload
	rv["down"] = download
	rv["total"] = total

	luci.http.prepare_content("application/json")
	luci.http.write_json(rv)
end

function action_get_user()
	local rv = {}

	local num = 0
	local ip = nil
	local mac = nil
	local download = nil
	local total = nil
	local str = ""
	local file = io.open("/tmp/usage.db", "r")
	if file ~= nil then
		repeat
			local line = file:read("*line")
			if line == nil then
				break
			end
			num = num + 1
			local t = Split(line, ",", 7)
			local pi = t[7]
			local host = nixio.getnameinfo(pi)
			local per, pere
			if host == nil then
				host = pi
			else
				per, pere = string.find(host, ".lan")
				local tt = host
				if per ~= nil then
					tt = string.sub(host, 1, per-1) 
					--tt = host
				end
				host = pi .. " ( " .. tt .. " )"
			end
			if ip ~= nil then
				ip = ip .. "$$" .. host
			else
				ip = host
			end
			if mac ~= nil then
				mac = mac .. "$$" .. t[1]
			else
				mac = t[1]
			end

			local temp = t[2]
			str = form(temp)
			if download ~= nil then
				download = download .. "$$" .. str
			else
				download = str
			end
			local temp = t[3]
			str = form(temp)
			if upload ~= nil then
				upload = upload .. "$$" .. str
			else
				upload = str
			end
			local tot = t[2] + t[3]
			str = form(tot)
			if total ~= nil then
				total = total .. "$$" .. str
			else
				total = str
			end
		until 1 == 0
		file:close()
	end

	rv["length"] = num
	rv["ip"] = ip
	rv["mac"] = mac
	rv["up"] = upload
	rv["down"] = download
	rv["total"] = total

	luci.http.prepare_content("application/json")
	luci.http.write_json(rv)
end

function action_get_user_tracker()
	local rv = {}

	local num = 0
	local ip = nil
	local mac = nil
	local download = nil
	local total = nil
	local str = ""
	local file = io.open("/tmp/tracker.db", "r")
	if file ~= nil then
		repeat
			local line = file:read("*line")
			if line == nil then
				break
			end
			num = num + 1
			local t = Split(line, ",", 7)
			local pi = t[7]
			local host = nixio.getnameinfo(pi)
			local per, pere
			if host == nil then
				host = pi
			else
				per, pere = string.find(host, ".lan")
				local tt = host
				if per ~= nil then
					tt = string.sub(host, 1, per-1) 
					--tt = host
				end
				host = pi .. " ( " .. tt .. " )"
			end
			if ip ~= nil then
				ip = ip .. "$$" .. host
			else
				ip = host
			end
			if mac ~= nil then
				mac = mac .. "$$" .. t[1]
			else
				mac = t[1]
			end

			local temp = t[2]
			str = form(temp)
			if download ~= nil then
				download = download .. "$$" .. str
			else
				download = str
			end
			local temp = t[3]
			str = form(temp)
			if upload ~= nil then
				upload = upload .. "$$" .. str
			else
				upload = str
			end
			local tot = t[2] + t[3]
			str = form(tot)
			if total ~= nil then
				total = total .. "$$" .. str
			else
				total = str
			end
		until 1 == 0
		file:close()
	end

	rv["length"] = num
	rv["ip"] = ip
	rv["mac"] = mac
	rv["up"] = upload
	rv["down"] = download
	rv["total"] = total

	luci.http.prepare_content("application/json")
	luci.http.write_json(rv)
end

