-- Copyright 2008 Steven Barth <steven@midlink.org>
-- Licensed to the public under the Apache License 2.0.

local wa = require "luci.tools.webadmin"
local fs = require "nixio.fs"

m = Map("passthrough", translate("IP Passthrough Setting"),
	translate("Using Passthrough Mode will disable most of the router capabilities"))

--s = m:section(TypedSection, "passthrough", translate("Server Settings"))
s = m:section(TypedSection, "passthrough")
s.anonymous = true
s.addremove = false

e = s:option(Flag, "enabled", translate("Enable"))
e.rmempty = false

mac = s:option(Value, "mac", translate("MAC Address"))
mac.datatype = "neg(macaddr)"

--gw = s:option(Value, "gateway", translate("Gateway"))
--gw.datatype = "neg(ip4addr)"

local apply = luci.http.formvalue("cbi.apply")
if apply then
	 io.popen("/etc/init.d/passthrough restart")
end


return m

