require("luci.tools.webadmin")
local uci = require "luci.model.uci".cursor_state()
local sys = require "luci.sys"

local zones = require "luci.sys.zoneinfo"
local fs    = require "nixio.fs"

function Split(str, delim, maxNb)
    -- Eliminate bad cases...
    if string.find(str, delim) == nil then
        return { str }
    end
    if maxNb == nil or maxNb < 1 then
        maxNb = 0    -- No limit
    end
    local result = {}
    local pat = "(.-)" .. delim .. "()"
    local nb = 0
    local lastPos
    for part, pos in string.gfind(str, pat) do
        nb = nb + 1
        result[nb] = part
        lastPos = pos
        if nb == maxNb then break end
    end
    -- Handle the last field
    if nb ~= maxNb then
        result[nb + 1] = string.sub(str, lastPos)
    end
    return result
end

local upload = 0
local download = 0
local file = io.open("/tmp/tracker.db", "r")
if file ~= nil then
	repeat
		local line = file:read("*line")
		if line == nil then
			break
		end
		local t = Split(line, ",", 6)
		download = download + t[2]
		upload = upload + t[3]
	until 1 == 0
	file:close()
end
total = upload + download
if total < 1000 then
	tstr = string.format("%d", total)
	tfm = "KB"
else
	if total < 1000000 then
		tstr = string.format("%g", total/1000)
		tfm = "MB"
	else
		tstr = string.format("%g", total/1000000)
		tfm = "GB"
	end
end
if upload < 1000 then
	upstr = string.format("%d", upload)
	ufm = "KB"
else
	if upload < 1000000 then
		upstr = string.format("%g", upload/1000)
		ufm = "MB"
	else
		upstr = string.format("%g", upload/1000000)
		ufm = "GB"
	end
end
if download < 1000 then
	dwnstr = string.format("%d", download)
	dfm = "KB"
else
	if download < 1000000 then
		dwnstr = string.format("%g", download/1000)
		dfm = "MB"
	else
		dwnstr = string.format("%g", download/1000000)
		dfm = "GB"
	end
end

os.execute("/etc/tracker writedl " .. dwnstr .. " " .. dfm .. " " .. upstr .. " " .. ufm .. " " .. tstr .. " " .. tfm)

m = Map("tracker", "Bandwidth Tracker")

m.on_after_commit = function(self)
	os.execute("/etc/trackerjob")
end

s = m:section(TypedSection, "monitor", "INFORMATION")
dummy = s:option(DummyValue, 3, "")
dummy.template = "cbi/tvalue"
dummy.rows = 5
function dummy.cfgvalue()
return "This feature will track the usage of all devices connected to the router and stop the Users going over the Bandwidth you set."
end

s = m:section(TypedSection, "monitor", "Bandwidth Tracker Settings")
s.addremove = false
s.anonymous = false

en1 = s:option(Flag, "enable", translate("Enabled"), "This will enable the Bandwidth Tracking per User")
en1.rmempty = false
en1.enabled = "1"
en1.disabled = "0"

function en1.cfgvalue(self, section)
	return Flag.cfgvalue(self, section) or "0"
end

reset = s:option(ListValue, "reset", "Reset Time :", "Enter Time to Reset Database")
reset:value("@midnight", "Midnight")
reset.rmempty = false

bandwidth = s:option(Value, "blimit", translate("Enter Max Bandwidth Per User"))
blimitsize = s:option(ListValue, "blimitsize", "BandWidth Limit Size")
blimitsize:value("1", "Kilobytes (KB)")
blimitsize:value("2", "Megabytes (MB)")
blimitsize:value("3", "Gigabytes (GB)")

clean = s:option(Button, "_btnpass", translate(" "))
clean.inputtitle = translate("Reset Data/Usage")
clean.inputstyle = "apply"

function clean.write()
	luci.sys.call("/etc/tracker reset")
end

s.anonymous = true
s.addremove = false
s.template = "cbi/tblsection"

s1 = m:section(TypedSection, "monitor", "Bandwidth Usage Amounts in Monitored Period")
s1.addremove = false
s1.anonymous = false

upl = s1:option(DummyValue, "up", "Total Uploaded Amount :")
dwnl = s1:option(DummyValue, "down", "Total Downloaded Amount :")
totl = s1:option(DummyValue, "total", "Total Bandwidth Amount :")

m:section(SimpleSection).template = "quick/tracker"

m2 = Map("trackerlimits", "Limits")
s3 = m2:section(TypedSection, "user", "Tracking List")
s3.anonymous = true
s3.addremove = true
s3.template = "cbi/tblsection"

name = s3:option(Value, "name", translate("Hostname"))
mac = s3:option(Value, "mac", translate("<abbr title=\"Media Access Control\">MAC</abbr>-Address"))
sys.net.arptable(function(entry)
        mac:value(
                entry["HW address"],
                entry["HW address"] .. " (" .. entry["IP address"] .. ")"
        )
end)

allow = s3:option(Flag, "allow", "No Restrictions")
allow.rmempty = false
allow.enabled = "1"
allow.disabled = "0"

dummy2 = s3:option(DummyValue, "dummy2", translate("Status"))
function dummy2.cfgvalue(self,section)
	local serial = uci:get("trackerlimits", section, "status")
	if serial == null then
		return "Not Blocked"
	end
	if serial == "Not Blocked" then
		return "Not Blocked"
	else
		return "Blocked!!"
	end
end

m3 = Map("system", translate("TimeZone"), translate("Here you can configure the timezone."))
s3 = m3:section(TypedSection, "system", translate("System Properties"))
o = s3:option(ListValue, "zonename", translate("Timezone"))
o:value("UTC")

for i, zone in ipairs(zones.TZ) do
	o:value(zone[1])
end

function o.write(self, section, value)
	local function lookup_zone(title)
		for _, zone in ipairs(zones.TZ) do
			if zone[1] == title then return zone[2] end
		end
	end

	AbstractValue.write(self, section, value)
	local timezone = lookup_zone(value) or "GMT0"
	self.map.uci:set("system", section, "timezone", timezone)
	fs.writefile("/etc/TZ", timezone .. "\n")
end

return m, m2, m3

