require("luci.tools.webadmin")
local sys = require "luci.sys"
local uci = require("luci.model.uci").cursor()

m = Map("blimits", "Speed Limiter")

m.on_after_commit = function(self)
	os.execute("/etc/blimit.sh")
end

s = m:section(NamedSection, "global", "Setup")
s.addremove = false
s.anonymous = false

enable = s:option(ListValue, "enabled", translate("Master Enable"))
enable:value("0", "OFF")
enable:value("1", "ON")
enable.rmempty = false

function enable.cfgvalue(self, section)
	return Flag.cfgvalue(self, section) or "0"
end

s = m:section(TypedSection, "limits", "Interface")
s.anonymous = true
s.addremove = true
s.template = "cbi/tblsection"

device = s:option(ListValue, "device", translate("Interface"))
device:value("br-lan", "LAN")
device:value("ra0", "Main WiFi (ra0)")
device:value("ra1", "Guest WiFi (ra1)")
device:value("apcli0", "Repeater Mode")
device.defaults="LAN"

enable2 = s:option(ListValue, "enabled", translate("Enabled"))
enable2:value("0", "OFF")
enable2:value("1", "ON")
enable2.defaults="0"
enable2.rmempty = false

function enable2.cfgvalue(self, section)
	return Flag.cfgvalue(self, section) or "0"
end

up = s:option(Value, "upload", translate("Upload Limit -kbps"))
up.rmempty = false

down = s:option(Value, "download", translate("Download Limit -kbps"))
down.rmempty = false

return m

