require("luci.tools.webadmin")
local sys = require "luci.sys"
local uci = require("luci.model.uci").cursor()

m = Map("macfilter", "Mac Filter Access Restrictions")

m.on_after_commit = function(self)
	os.execute("/etc/macfilter.sh")
end

s = m:section(NamedSection, "macfilter", "Mac Filter Setup")
enable = s:option(ListValue, "enabled", translate("Enable Mac Filter"))
enable:value("0", "OFF")
enable:value("1", "ON")

function enable.cfgvalue(self, section)
	return Flag.cfgvalue(self, section) or "0"
end

policy = s:option(ListValue, "policy", translate("Policy"))
policy:value("0", "Allow All but block list below")
policy:value("1", "Reject All but Allow list below ")

time_sched = s:option(ListValue, "time_sched", translate("Time Restrictions"), translate("Press Save for setting to take effect before Adding Mac Addresses"))
time_sched:value("0", "OFF")
time_sched:value("1", "ON-global")
time_sched:value("2", "ON-peruser")

start_time = s:option(Value, "starttime", translate("Start Time (24hr format)"))
start_time.default="06:00:00"
start_time:depends({time_sched=1})

end_time = s:option(Value, "endtime", translate("End Time (24hr format)"))
end_time.default="21:30:00"
end_time:depends({time_sched=1})

s1 = m:section(TypedSection, "user", "List of Mac Addresses")
s1.anonymous = true
s1.addremove = true
s1.template = "cbi/tblsection"

name = s1:option(Value, "name", translate("Label (Optional)"))
mac = s1:option(Value, "mac", translate("<abbr title=\"Media Access Control\">MAC</abbr>-Address"))
sys.net.arptable(function(entry)
        mac:value(
                entry["HW address"],
                entry["HW address"] .. " (" .. entry["IP address"] .. ")"
        )
end)

ports = s1:option(Value, "uports", translate("Ports (Optional)"), translate("Default is ALL PORTS (ex: 80,21,23 or range 21:24)"))
block = s1:option(Flag, "noaccess", translate("Total Block (Optional)"), translate("when enabled will deny all access to router/internet for user"))

local time_sched = m.uci:get("macfilter", "macfilter", "time_sched")
local time_sched = uci:get("macfilter", "macfilter", "time_sched")
if time_sched == "2" then
	perstart_time = s1:option(Value, "starttime", translate("Start (24hr format)"))
	perstart_time.default="07:00:00"
	--perstart_time:depends({time_sched=2})

	perend_time = s1:option(Value, "endtime", translate("End (24hr format)"))
	perend_time.default="21:30:00"
	--perend_time:depends({time_sched=2})
end

restrictions = s1:option(ListValue, "restrictions", translate("Bypass Time Restrictions (Optional)"), translate("Will bypass time restrictions for certain devices"))
restrictions:value("0", "Yes")
restrictions:value("1", "No")
restrictions.default="1"

--restrictions = s1:option(Flag, "restrictions", translate("Bypass Time Restrictions (Optional)"), translate("Will bypass time restrictions for certain devices"))
--restrictions.rmempty = true
--restrictions.enabled = "0"
--restrictions.disabled = "1"

s = m:section(NamedSection, "macfilter", translate("Global"))
s:option(DynamicList, "white_list", translate("Global WhiteList"),translate("Here you can Limit Users to certain websites (Depending on Policy)"))
s:option(DynamicList, "ports", translate("Global PortList"),translate("Here you can Limit Users to certain ports (Depending on Policy)"))

s:option(Flag, "google", translate("Google Gmail"), translate("Allow/Deny Access to Google's GMAIL Servers"))

return m

