require("luci.tools.webadmin")
local uci = require "luci.model.uci".cursor_state()
local sys = require "luci.sys"

m = Map("monitor", "Bandwidth Monitoring")

m.on_after_commit = function(self)
	os.execute("/etc/monitor 2>&1 >/dev/null")
end

s = m:section(TypedSection, "monitor", "INFORMATION")
dummy = s:option(DummyValue, 3, "")
dummy.template = "cbi/tvalue"
dummy.rows = 5
function dummy.cfgvalue()
return "This feature will monitor the usage of all devices connected to the router. \
Click on the checkbox to enable and select a Reset Day this feature to be active. \
You should find out when your monthly usage gets reset with your provider and set the date to that. \
This way, your usage can match your billing from your provider."
end

s = m:section(TypedSection, "monitor", "Bandwidth Usage Settings")
s.addremove = false
s.anonymous = false

en1 = s:option(Flag, "enable", translate("Enabled"), "This will enable the Bandwidth Monitoring per User")
en1.rmempty = false
en1.enabled = "1"
en1.disabled = "0"

function en1.cfgvalue(self, section)
	return Flag.cfgvalue(self, section) or "0"
end

--lan = s:option(Flag, "lantraffic", translate("Include All Traffic into Usage"), "This will enable Bandwidth Usage for EVERYTHING LAN and INTERNET")
--lan.rmempty = false
--lan.enabled = "1"
--lan.disabled = "0"

s.anonymous = true
s.addremove = false
s.template = "cbi/tblsection"

month = s:option(ListValue, "month", "Reset Month :", "Enter Month to Reset Database")
month:value("*", "Every Month")
month:value("1", "Jan")
month:value("2", "Feb")
month:value("3", "Mar")
month:value("4", "Apr")
month:value("5", "May")
month:value("6", "Jun")
month:value("7", "Jul")
month:value("8", "Aug")
month:value("9", "Sep")
month:value("10", "Oct")
month:value("11", "Nov")
month:value("12", "Dec")
month.default = "*"
month.delimiter = ","
month.rmempty = false

daym = s:option(ListValue, "day", "Reset Day :", "Enter Your Billing Date to Reset Billing Period")
daym:value("*", "Every Day")
daym:value("1", "1st")
daym:value("2", "2nd")
daym:value("3", "3rd")
daym:value("4", "4th")
daym:value("5", "5th")
daym:value("6", "6th")
daym:value("7", "7th")
daym:value("8", "8th")
daym:value("9", "9th")
daym:value("10", "10th")
daym:value("11", "11th")
daym:value("12", "12th")
daym:value("13", "13th")
daym:value("14", "14th")
daym:value("15", "15th")
daym:value("16", "16th")
daym:value("17", "17th")
daym:value("18", "18th")
daym:value("19", "19th")
daym:value("20", "20th")
daym:value("21", "21st")
daym:value("22", "22nd")
daym:value("23", "23rd")
daym:value("24", "24th")
daym:value("25", "25th")
daym:value("26", "26th")
daym:value("27", "27th")
daym:value("28", "28th")
daym:value("29", "29th")
daym:value("30", "30th")
daym:value("31", "31st")
daym.default = "*"
daym.delimiter = ","
daym.rmempty = false

s = m:section(TypedSection, "monitor", "Internet block on exceeded bandwidth", "When the Total Bandwidth Amount exceeds this threshold, Internet access will be blocked")
internet_block_en = s:option(Flag, "internet_block_enabled", translate("Enabled"))
internet_block_en.default = "0"
internet_cap_bw = s:option(Value, "internet_cap_bw", translate("Bandwidth Threshold"))
internet_cap_bw.default = "0"
blimitsize = s:option(ListValue, "internet_cap_unit", "BandWidth Threshold Unit")
blimitsize:value("1", "Kilobytes (KB)")
blimitsize:value("2", "Megabytes (MB)")
blimitsize:value("3", "Gigabytes (GB)")
blimitsize.default = "0"
dummy2 = s:option(DummyValue, "dummy2", translate("Internet Block Status"))
function dummy2.cfgvalue(self,section)
	local status = uci:get("monitor", section, "internet_block_status")
	if status == null then
		return "unknown"
	end
	return status 
end

s1 = m:section(TypedSection, "monitor", "Bandwidth Usage Amounts in Monitored Period")
s1.addremove = false
s1.anonymous = false

upl = s1:option(DummyValue, "up", "Total Uploaded Amount :")
dwnl = s1:option(DummyValue, "down", "Total Downloaded Amount :")
totl = s1:option(DummyValue, "total", "Total Bandwidth Amount :")
ototl = s1:option(DummyValue, "oldtot", "Previous Period Total Bandwidth Amount :")

m:section(SimpleSection).template = "rooter/user"

btn1 = s1:option(Button, "_btn1", translate("Press Here to Reset Usage Database Previous Months Totals will be Erased, Internet block will also be reset"), translate("This Button will run a script to remove the database"))
function btn1.write()
	os.execute("/etc/wrtbwmon fullreset 2>&1 >/dev/null &")
	--luci.sys.call("/etc/wrtbwmon reset /tmp/usage.db /etc/config/usage.db")
end

--[[
--dawsen delete
m2 = Map("userlimits", "User Limits")
m2.on_after_commit = function(self)
	os.execute("/etc/wrtbwmon updateandcap 2>&1 >/dev/null &")
end
s2 = m2:section(NamedSection, "global", "User Bandwidth Settings")

en3 = s2:option(Flag, "enabled", translate("Enabled"))
en3.rmempty = false
en3.enabled = "1"
en3.disabled = "0"

function en3.cfgvalue(self, section)
	return Flag.cfgvalue(self, section) or "0"
end

policy = s2:option(ListValue, "policy", translate("Policy"))
policy.rmempty = false
policy:value("0", "Allow All")
policy:value("1", "Block All EXCEPT for list")

s3 = m2:section(TypedSection, "user", "User Bandwidth Block List")
s3.anonymous = true
s3.addremove = true
s3.template = "cbi/tblsection"

name = s3:option(Value, "name", translate("Hostname"))
mac = s3:option(Value, "mac", translate("<abbr title=\"Media Access Control\">MAC</abbr>-Address"))
sys.net.arptable(function(entry)
        mac:value(
                entry["HW address"],
                entry["HW address"] .. " (" .. entry["IP address"] .. ")"
        )
end)
bandwidth = s3:option(Value, "blimit", translate("Bandwidth Limit"))
blimitsize = s3:option(ListValue, "blimitsize", "BandWidth Limit Size")
blimitsize:value("1", "Kilobytes (KB)")
blimitsize:value("2", "Megabytes (MB)")
blimitsize:value("3", "Gigabytes (GB)")

action = s3:option(ListValue, "action", translate("Action"))
action:value("block", "block")
action:value("allow", "allow")
action:value("throttle", "throttle")
action.rmempty = true

up_speed = s3:option(Value, "up_speed", translate("Throttle Up (Kbps)"))
up_speed:depends("action", "throttle")
up_speed.rmempty = true
up_speed.default = "1000"

down_speed = s3:option(Value, "down_speed", translate("Throttle Down (Kbps)"))
down_speed:depends("action", "throttle")
down_speed.rmempty = true
down_speed.default = "1000"

reset = s3:option(Button, "reset", translate("Reset?"))
reset.inputtitle = translate("Reset")
reset.inputstyle = "reset"

reset.write = function(self, section, value)
	if value == "Reset" then
		self.map.uci:set("userlimits", section, "reset", 1)
		--luci.sys.call("/etc/wrtbwmon updateandcap")
	end
end

dummy2 = s3:option(DummyValue, "dummy2", translate("Status"))
function dummy2.cfgvalue(self,section)
	local status = uci:get("userlimits", section, "status")
	if status == null then
		return "unknown"
	end
	return status 
end

--reset.inputtitle = translate("Reset")
--reset.inputstyle = "reset"
--reset.write = function(self, section)
--	luci.sys.call("/etc/luaops.sh delete %s %s >/dev/null" %{ section.name, self.option })
--end


return m, m2

]]--
return m