#include <linux/uaccess.h>
#include <linux/inetdevice.h>
#include <linux/seq_file.h>
#include <linux/string.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/uaccess.h>
#include "filter_log.h"
#include "filter_proc.h"
#include "pkt_filter.h"

static struct proc_dir_entry *proc;

static int proc_ip_show(struct seq_file *s, void *v)
{
    //seq_printf(s, "url = %s\n", conf.url);
    seq_printf(s,"IP");
    return 0;
}

static int proc_domain_show(struct seq_file *s, void *v)
{
    //seq_printf(s, "url = %s\n", conf.url);
    seq_printf(s, "Doamin\n");
    return 0;
}

static ssize_t proc_ip_write(struct file *file, const char __user *buf, size_t size, loff_t *ppos)
{
    char data[2048];
    const char s[2] = " ";
    char *token=NULL;
    char *p;
    
    if (size == 0)
        return -EINVAL;

    if (size > sizeof(data))
        size = sizeof(data);

    memset(data, 0, sizeof(data));
    if (copy_from_user(data, buf, size))
        return -EFAULT;

     ip_clean_list();
     p = data;
     token = strsep(&p, s);
     while( token != NULL ) 
     {
        AF_DEBUG( "ip:%s len:%d\n", token,strlen(token) );
        add_ip_node(token);
        token = strsep(&p, s);
    }
    return size;
}

static ssize_t proc_domain_write(struct file *file, const char __user *buf, size_t size, loff_t *ppos)
{
    char data[2048];
    const char s[2] = " ";
    char *token=NULL;
    char *p = NULL;
    char domain[128] = {0};
    char *q = NULL;
    int i = 0;
    
    if (size == 0)
        return -EINVAL;

    if (size > sizeof(data))
        size = sizeof(data);

    memset(data, 0, sizeof(data));
    if (copy_from_user(data, buf, size))
        return -EFAULT;

    domain_clean_list();
    
    p = data;
    token = strsep(&p, s);
     while( token != NULL ) 
     {
        AF_DEBUG( "domain:%s len:%d\n", token,strlen(token));
        add_domain_node(token);
        token = strsep(&p, s);
    }
    return size;
}

static int proc_ip_open(struct inode *inode, struct file *file)
{
    return single_open(file, proc_ip_show, NULL);
}

static int proc_domain_open(struct inode *inode, struct file *file)
{
    return single_open(file, proc_domain_show, NULL);
}

const static struct file_operations proc_ip_ops = {
    //.owner      = THIS_MODULE,
    .open       = proc_ip_open,
    .read       = seq_read,
    .write      = proc_ip_write,
    .llseek     = seq_lseek,
    .release    = single_release
};

const static struct file_operations proc_domain_ops = {
    //.owner      = THIS_MODULE,
    .open       = proc_domain_open,
    .read       = seq_read,
    .write      = proc_domain_write,
    .llseek     = seq_lseek,
    .release    = single_release
};

int init_config(void)
{
    int ret = 0;

    proc = proc_mkdir(PROC_DIR_NAME, NULL);
    if (!proc) {
        pr_err("can't create dir /proc/"PROC_DIR_NAME"/\n");
        return -ENODEV;;
    }

    if (!proc_create("ip", 0644, proc, &proc_ip_ops)) {
        pr_err("can't create file /proc/"PROC_DIR_NAME"/ip\n");
        ret = -EINVAL;
        goto remove;
    }

    if (!proc_create("domain", 0644, proc, &proc_domain_ops)) {
        pr_err("can't create file /proc/"PROC_DIR_NAME"/domain\n");
        ret = -EINVAL;
        goto remove;
    }

    return 0;

remove:
    remove_proc_entry(PROC_DIR_NAME, NULL);
    return ret;
}

void deinit_config(void)
{
    remove_proc_entry("ip", proc);
    remove_proc_entry("domain", proc);
    remove_proc_entry(PROC_DIR_NAME, NULL);
}