#ifndef _PKT_FILTER_H_
#define _PKT_FILTER_H_

struct dns_reply_head
{
        uint16_t id;
        uint16_t flag;
        uint16_t qnum;
        uint16_t anum;
        uint16_t aunum;
        uint16_t adnum;
}__attribute__ ((__packed__));

struct dns_reply_query
{
        uint8_t name[64];
        uint16_t type;
        uint16_t class;
};

struct dns_reply_answer
{
        uint16_t namep;
        uint16_t type;
        uint16_t class;
        uint32_t ttl;
        uint16_t len;
        uint8_t data[0];
}__attribute__ ((__packed__));

typedef struct domain_node{
	struct list_head  head;
	char domain[64];
}domain_node_t;

typedef struct ip_node{
	struct list_head  head;
	char ip[64];
}ip_node_t;

extern int g_ip_filter_enable;
extern int g_domain_filter_enable;
extern int g_ip_whitelist_enable;
extern int g_domain_whitelist_enable;

int add_domain_node(const char *domain);
int add_ip_node(const char *ip);

void domain_clean_list(void);
void ip_clean_list(void);
#endif