/*
 * Copyright (c) 2013-2017 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */

/**=========================================================================

  \file  macTrace.c

  \brief implementation for trace related APIs

  \author Sunit Bhatia

  ========================================================================*/


/*--------------------------------------------------------------------------
  Include Files
  ------------------------------------------------------------------------*/

#include "macTrace.h"
#include "wlan_qct_wda.h"
#include "wlan_qct_wda_msg.h"
#include "wlan_hdd_assoc.h"
#include "wlan_hdd_main.h"
#include "wlan_hdd_p2p.h"
#include "csrNeighborRoam.h"
#include "csrInternal.h"
#include "limGlobal.h"
#include "limTypes.h"
#include "wlan_qct_tl.h"
#include "vos_memory.h"
#include "wlan_qct_wda.h"
#include "vos_trace.h"

#ifdef TRACE_RECORD

/* ---------------------------------------------------------------------------
    \fn macTraceGetHDDWlanConnState
    \function to get string equivalent of a value
	 from the enum eConnectionState.

    \param connState - the value from the enum
    \return the string equivalent of connState
  ---------------------------------------------------------------------------*/
tANI_U8* macTraceGetHDDWlanConnState(tANI_U16 connState)
{
	switch(connState)
	{
	CASE_RETURN_STRING(eConnectionState_NotConnected);
	CASE_RETURN_STRING(eConnectionState_Connecting);
	CASE_RETURN_STRING(eConnectionState_Associated);
	CASE_RETURN_STRING(eConnectionState_IbssDisconnected);
	CASE_RETURN_STRING(eConnectionState_IbssConnected);
	CASE_RETURN_STRING(eConnectionState_Disconnecting);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
	}
}

/* ---------------------------------------------------------------------------
    \fn macTraceGetP2PConnState
    \function to get string equivalent of a value
	 from the enum tP2PConnectionStatus.

    \param connState - the value from the enum
    \return the string equivalent of connState
  ---------------------------------------------------------------------------*/
#ifdef WLAN_FEATURE_P2P_DEBUG
tANI_U8* macTraceGetP2PConnState(tANI_U16 connState)
{
	switch(connState)
	{
	CASE_RETURN_STRING(P2P_NOT_ACTIVE);
	CASE_RETURN_STRING(P2P_GO_NEG_PROCESS);
	CASE_RETURN_STRING(P2P_GO_NEG_COMPLETED);
	CASE_RETURN_STRING(P2P_CLIENT_CONNECTING_STATE_1);
	CASE_RETURN_STRING(P2P_GO_COMPLETED_STATE);
	CASE_RETURN_STRING(P2P_CLIENT_CONNECTED_STATE_1);
	CASE_RETURN_STRING(P2P_CLIENT_DISCONNECTED_STATE);
	CASE_RETURN_STRING(P2P_CLIENT_CONNECTING_STATE_2);
	CASE_RETURN_STRING(P2P_CLIENT_COMPLETED_STATE);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
	}
}
#endif

/* ---------------------------------------------------------------------------
    \fn macTraceGetNeighbourRoamState
    \function to get string equivalent of a value
	 from the enum eCsrNeighborRoamState.

    \param neighbourRoamState - the value from the enum
    \return the string equivalent of neighbourRoamState
  ---------------------------------------------------------------------------*/
tANI_U8* macTraceGetNeighbourRoamState(tANI_U16 neighbourRoamState)
{
	switch(neighbourRoamState)
	{
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_CLOSED);
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_INIT);
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_CONNECTED);
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_CFG_CHAN_LIST_SCAN);
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_REASSOCIATING);
#ifdef WLAN_FEATURE_VOWIFI_11R
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_REPORT_QUERY);
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_REPORT_SCAN);
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_PREAUTHENTICATING);
	CASE_RETURN_STRING(eCSR_NEIGHBOR_ROAM_STATE_PREAUTH_DONE);
#endif /* WLAN_FEATURE_VOWIFI_11R */
	CASE_RETURN_STRING(eNEIGHBOR_STATE_MAX);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
	}
}

/* ---------------------------------------------------------------------------
    \fn macTraceGetcsrRoamState
    \function to get string equivalent of a value
	 from the enum eCsrRoamState.

    \param csrRoamState - the value from the enum
    \return the string equivalent of csrRoamState
  ---------------------------------------------------------------------------*/
tANI_U8* macTraceGetcsrRoamState(tANI_U16 csrRoamState)
{
	switch(csrRoamState)
	{
	CASE_RETURN_STRING(eCSR_ROAMING_STATE_STOP);
	CASE_RETURN_STRING(eCSR_ROAMING_STATE_IDLE);
	CASE_RETURN_STRING(eCSR_ROAMING_STATE_SCANNING);
	CASE_RETURN_STRING(eCSR_ROAMING_STATE_JOINING);
	CASE_RETURN_STRING(eCSR_ROAMING_STATE_JOINED);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
	}
}

/* ---------------------------------------------------------------------------
    \fn macTraceGetcsrRoamSubState
    \function to get string equivalent of a value
	 from the enum eCsrRoamSubState.

    \param csrRoamSubState - the value from the enum
    \return the string equivalent of csrRoamSubState
  ---------------------------------------------------------------------------*/
tANI_U8* macTraceGetcsrRoamSubState(tANI_U16 csrRoamSubState)
{
	switch(csrRoamSubState)
	{
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_NONE);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_START_BSS_REQ);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_JOIN_REQ);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_REASSOC_REQ);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_DISASSOC_REQ);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_STOP_BSS_REQ);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_DISCONNECT_CONTINUE_ROAMING);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_AUTH_REQ);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_CONFIG);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_DEAUTH_REQ);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_DISASSOC_NOTHING_TO_JOIN);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_DISASSOC_REASSOC_FAILURE);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_DISASSOC_FORCED);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_WAIT_FOR_KEY);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_DISASSOC_HANDOFF);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_JOINED_NO_TRAFFIC);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_JOINED_NON_REALTIME_TRAFFIC);
	CASE_RETURN_STRING(eCSR_ROAM_SUBSTATE_JOINED_REALTIME_TRAFFIC);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
	}
}

/* ---------------------------------------------------------------------------
    \fn macTraceGetLimSmeState
    \function to get string equivalent of a value
	 from the enum tLimSmeStates.

    \param limState - the value from the enum
    \return the string equivalent of limState
  ---------------------------------------------------------------------------*/
tANI_U8* macTraceGetLimSmeState(tANI_U16 limState)
{
	switch(limState)
	{
	CASE_RETURN_STRING(eLIM_SME_OFFLINE_STATE);
	CASE_RETURN_STRING(eLIM_SME_IDLE_STATE);
	CASE_RETURN_STRING(eLIM_SME_SUSPEND_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_SCAN_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_JOIN_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_AUTH_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_ASSOC_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_REASSOC_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_REASSOC_LINK_FAIL_STATE);
	CASE_RETURN_STRING(eLIM_SME_JOIN_FAILURE_STATE);
	CASE_RETURN_STRING(eLIM_SME_ASSOCIATED_STATE);
	CASE_RETURN_STRING(eLIM_SME_REASSOCIATED_STATE);
	CASE_RETURN_STRING(eLIM_SME_LINK_EST_STATE);
	CASE_RETURN_STRING(eLIM_SME_LINK_EST_WT_SCAN_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_PRE_AUTH_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_DISASSOC_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_DEAUTH_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_START_BSS_STATE);
	CASE_RETURN_STRING(eLIM_SME_WT_STOP_BSS_STATE);
	CASE_RETURN_STRING(eLIM_SME_NORMAL_STATE);
	CASE_RETURN_STRING(eLIM_SME_CHANNEL_SCAN_STATE);
	CASE_RETURN_STRING(eLIM_SME_NORMAL_CHANNEL_SCAN_STATE);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
	}
}

/* ---------------------------------------------------------------------------
    \fn macTraceGetLimMlmState
    \function to get string equivalent of a value
	 from the enum tLimMlmStates.

    \param mlmState - the value from the enum
    \return the string equivalent of mlmState
  ---------------------------------------------------------------------------*/
tANI_U8* macTraceGetLimMlmState(tANI_U16 mlmState)
{
	switch(mlmState)
	{
	CASE_RETURN_STRING(eLIM_MLM_OFFLINE_STATE);
	CASE_RETURN_STRING(eLIM_MLM_IDLE_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_PROBE_RESP_STATE);
	CASE_RETURN_STRING(eLIM_MLM_PASSIVE_SCAN_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_JOIN_BEACON_STATE);
	CASE_RETURN_STRING(eLIM_MLM_JOINED_STATE);
	CASE_RETURN_STRING(eLIM_MLM_BSS_STARTED_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_AUTH_FRAME2_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_AUTH_FRAME3_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_AUTH_FRAME4_STATE);
	CASE_RETURN_STRING(eLIM_MLM_AUTH_RSP_TIMEOUT_STATE);
	CASE_RETURN_STRING(eLIM_MLM_AUTHENTICATED_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_ASSOC_RSP_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_REASSOC_RSP_STATE);
	CASE_RETURN_STRING(eLIM_MLM_ASSOCIATED_STATE);
	CASE_RETURN_STRING(eLIM_MLM_REASSOCIATED_STATE);
	CASE_RETURN_STRING(eLIM_MLM_LINK_ESTABLISHED_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_ASSOC_CNF_STATE);
	CASE_RETURN_STRING(eLIM_MLM_LEARN_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_ADD_BSS_RSP_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_DEL_BSS_RSP_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_ADD_BSS_RSP_ASSOC_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_ADD_BSS_RSP_REASSOC_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_ADD_BSS_RSP_PREASSOC_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_ADD_STA_RSP_STATE);
	CASE_RETURN_STRING(eLIM_MLM_WT_DEL_STA_RSP_STATE);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
	}
}

/* ---------------------------------------------------------------------------
    \fn macTraceGetTLState
    \function to get string equivalent of a value
	 from the enum WLANTL_STAStateType.

    \param tlState - the value from the enum
    \return the string equivalent of tlState
  ---------------------------------------------------------------------------*/
tANI_U8* macTraceGetTLState(tANI_U16 tlState)
{
	switch(tlState)
	{
	CASE_RETURN_STRING(WLANTL_STA_INIT);
	CASE_RETURN_STRING(WLANTL_STA_CONNECTED);
	CASE_RETURN_STRING(WLANTL_STA_AUTHENTICATED);
	CASE_RETURN_STRING(WLANTL_STA_DISCONNECTED);
	CASE_RETURN_STRING(WLANTL_STA_MAX_STATE);

	default:
		return( (tANI_U8*)"UNKNOWN" );
		break;
   }
}

tANI_U8* macTraceGetSmeMsgString(tANI_U16 smeMsg)
{
	switch(smeMsg)
	{
	CASE_RETURN_STRING(eWNI_SME_START_REQ);
	CASE_RETURN_STRING(eWNI_SME_START_RSP);
	CASE_RETURN_STRING(eWNI_SME_SYS_READY_IND);
	CASE_RETURN_STRING(eWNI_SME_SCAN_REQ);
	CASE_RETURN_STRING(eWNI_SME_SCAN_ABORT_IND);
	CASE_RETURN_STRING(eWNI_SME_SCAN_RSP);
#ifdef FEATURE_OEM_DATA_SUPPORT
	CASE_RETURN_STRING(eWNI_SME_OEM_DATA_REQ);
	CASE_RETURN_STRING(eWNI_SME_OEM_DATA_RSP);
#endif
	CASE_RETURN_STRING(eWNI_SME_JOIN_REQ);
	CASE_RETURN_STRING(eWNI_SME_JOIN_RSP);
	CASE_RETURN_STRING(eWNI_SME_SETCONTEXT_REQ);
	CASE_RETURN_STRING(eWNI_SME_SETCONTEXT_RSP);
	CASE_RETURN_STRING(eWNI_SME_REASSOC_REQ);
	CASE_RETURN_STRING(eWNI_SME_REASSOC_RSP);
	CASE_RETURN_STRING(eWNI_SME_DISASSOC_REQ);
	CASE_RETURN_STRING(eWNI_SME_DISASSOC_RSP);
	CASE_RETURN_STRING(eWNI_SME_DISASSOC_IND);
	CASE_RETURN_STRING(eWNI_SME_DISASSOC_CNF);
	CASE_RETURN_STRING(eWNI_SME_DEAUTH_REQ);
	CASE_RETURN_STRING(eWNI_SME_DEAUTH_RSP);
	CASE_RETURN_STRING(eWNI_SME_DEAUTH_IND);
	CASE_RETURN_STRING(eWNI_SME_WM_STATUS_CHANGE_NTF);
	CASE_RETURN_STRING(eWNI_SME_IBSS_NEW_PEER_IND);
	CASE_RETURN_STRING(eWNI_SME_IBSS_PEER_DEPARTED_IND);
	CASE_RETURN_STRING(eWNI_SME_START_BSS_REQ);
	CASE_RETURN_STRING(eWNI_SME_START_BSS_RSP);
	CASE_RETURN_STRING(eWNI_SME_AUTH_IND);
	CASE_RETURN_STRING(eWNI_SME_ASSOC_IND);
	CASE_RETURN_STRING(eWNI_SME_ASSOC_CNF);
	CASE_RETURN_STRING(eWNI_SME_REASSOC_IND);
	CASE_RETURN_STRING(eWNI_SME_REASSOC_CNF);
	CASE_RETURN_STRING(eWNI_SME_SWITCH_CHL_REQ);
	CASE_RETURN_STRING(eWNI_SME_SWITCH_CHL_RSP);
	CASE_RETURN_STRING(eWNI_SME_STOP_BSS_REQ);
	CASE_RETURN_STRING(eWNI_SME_STOP_BSS_RSP);
	CASE_RETURN_STRING(eWNI_SME_DEFINE_QOS_REQ);
	CASE_RETURN_STRING(eWNI_SME_DEFINE_QOS_RSP);
	CASE_RETURN_STRING(eWNI_SME_DELETE_QOS_REQ);
	CASE_RETURN_STRING(eWNI_SME_DELETE_QOS_RSP);
	CASE_RETURN_STRING(eWNI_SME_LINK_TEST_START_REQ);
	CASE_RETURN_STRING(eWNI_SME_LINK_TEST_START_RSP);
	CASE_RETURN_STRING(eWNI_SME_LINK_TEST_STOP_REQ);
	CASE_RETURN_STRING(eWNI_SME_LINK_TEST_STOP_RSP);
	CASE_RETURN_STRING(eWNI_SME_LINK_TEST_REPORT_IND);
	CASE_RETURN_STRING(eWNI_SME_NEIGHBOR_BSS_IND);
	CASE_RETURN_STRING(eWNI_SME_MEASUREMENT_REQ);
	CASE_RETURN_STRING(eWNI_SME_MEASUREMENT_RSP);
	CASE_RETURN_STRING(eWNI_SME_MEASUREMENT_IND);
	CASE_RETURN_STRING(eWNI_SME_SET_WDS_INFO_REQ);
	CASE_RETURN_STRING(eWNI_SME_SET_WDS_INFO_RSP);
	CASE_RETURN_STRING(eWNI_SME_WDS_INFO_IND);
	CASE_RETURN_STRING(eWNI_SME_SET_POWER_REQ);
	CASE_RETURN_STRING(eWNI_SME_SET_POWER_RSP);
	CASE_RETURN_STRING(eWNI_SME_CLIENT_SIDE_LOAD_BALANCE_REQ);
	CASE_RETURN_STRING(eWNI_SME_CLIENT_SIDE_LOAD_BALANCE_RSP);
	CASE_RETURN_STRING(eWNI_SME_SELECT_CHANNEL_REQ);
	CASE_RETURN_STRING(eWNI_SME_SELECT_CHANNEL_RSP);
	CASE_RETURN_STRING(eWNI_SME_SET_PROPRIETARY_IE_REQ);
	CASE_RETURN_STRING(eWNI_SME_SET_PROPRIETARY_IE_RSP); // #endif
	CASE_RETURN_STRING(eWNI_SME_DISCARD_SKB_NTF);  // Used to cleanup SKBs by HDD
	CASE_RETURN_STRING(eWNI_SME_DEAUTH_CNF);
	CASE_RETURN_STRING(eWNI_SME_MIC_FAILURE_IND);
	CASE_RETURN_STRING(eWNI_SME_ADDTS_REQ);
	CASE_RETURN_STRING(eWNI_SME_ADDTS_RSP);
	CASE_RETURN_STRING(eWNI_SME_ADDTS_CNF);
	CASE_RETURN_STRING(eWNI_SME_ADDTS_IND);
	CASE_RETURN_STRING(eWNI_SME_DELTS_REQ);
	CASE_RETURN_STRING(eWNI_SME_DELTS_RSP);
	CASE_RETURN_STRING(eWNI_SME_DELTS_IND);
	CASE_RETURN_STRING(eWNI_SME_SET_BACKGROUND_SCAN_MODE_REQ);
	CASE_RETURN_STRING(eWNI_SME_SWITCH_CHL_CB_PRIMARY_REQ);
	CASE_RETURN_STRING(eWNI_SME_SWITCH_CHL_CB_PRIMARY_RSP);
	CASE_RETURN_STRING(eWNI_SME_SWITCH_CHL_CB_SECONDARY_REQ);
	CASE_RETURN_STRING(eWNI_SME_SWITCH_CHL_CB_SECONDARY_RSP);
	CASE_RETURN_STRING(eWNI_SME_PROBE_REQ);
	CASE_RETURN_STRING(eWNI_SME_STA_STAT_REQ);
	CASE_RETURN_STRING(eWNI_SME_STA_STAT_RSP);
	CASE_RETURN_STRING(eWNI_SME_AGGR_STAT_REQ);
	CASE_RETURN_STRING(eWNI_SME_AGGR_STAT_RSP);
	CASE_RETURN_STRING(eWNI_SME_GLOBAL_STAT_REQ);
	CASE_RETURN_STRING(eWNI_SME_GLOBAL_STAT_RSP);
	CASE_RETURN_STRING(eWNI_SME_STAT_SUMM_REQ);
	CASE_RETURN_STRING(eWNI_SME_STAT_SUMM_RSP);
	CASE_RETURN_STRING(eWNI_SME_REMOVEKEY_REQ);
	CASE_RETURN_STRING(eWNI_SME_REMOVEKEY_RSP);
	CASE_RETURN_STRING(eWNI_SME_GET_SCANNED_CHANNEL_REQ);
	CASE_RETURN_STRING(eWNI_SME_GET_SCANNED_CHANNEL_RSP);
	CASE_RETURN_STRING(eWNI_SME_SET_TX_POWER_REQ);
	CASE_RETURN_STRING(eWNI_SME_SET_TX_POWER_RSP);
	CASE_RETURN_STRING(eWNI_SME_GET_TX_POWER_REQ);
	CASE_RETURN_STRING(eWNI_SME_GET_TX_POWER_RSP);
	CASE_RETURN_STRING(eWNI_SME_GET_NOISE_REQ);
	CASE_RETURN_STRING(eWNI_SME_GET_NOISE_RSP);
	CASE_RETURN_STRING(eWNI_SME_LOW_RSSI_IND);
	CASE_RETURN_STRING(eWNI_SME_GET_STATISTICS_REQ);
	CASE_RETURN_STRING(eWNI_SME_GET_STATISTICS_RSP);
	CASE_RETURN_STRING(eWNI_SME_GET_RSSI_REQ);
	CASE_RETURN_STRING(eWNI_SME_GET_ASSOC_STAS_REQ);
	CASE_RETURN_STRING(eWNI_SME_TKIP_CNTR_MEAS_REQ);
	CASE_RETURN_STRING(eWNI_SME_UPDATE_APWPSIE_REQ);
	CASE_RETURN_STRING(eWNI_SME_GET_WPSPBC_SESSION_REQ);
	CASE_RETURN_STRING(eWNI_SME_WPS_PBC_PROBE_REQ_IND);
	CASE_RETURN_STRING(eWNI_SME_SET_APWPARSNIEs_REQ);
	CASE_RETURN_STRING(eWNI_SME_UPPER_LAYER_ASSOC_CNF);
	CASE_RETURN_STRING(eWNI_SME_HIDE_SSID_REQ);
	CASE_RETURN_STRING(eWNI_SME_CHNG_MCC_BEACON_INTERVAL);
	CASE_RETURN_STRING(eWNI_SME_REMAIN_ON_CHANNEL_REQ);
	CASE_RETURN_STRING(eWNI_SME_REMAIN_ON_CHN_IND);
	CASE_RETURN_STRING(eWNI_SME_REMAIN_ON_CHN_RSP);
	CASE_RETURN_STRING(eWNI_SME_REMAIN_ON_CHN_RDY_IND);
	CASE_RETURN_STRING(eWNI_SME_SEND_ACTION_FRAME_IND);
	CASE_RETURN_STRING(eWNI_SME_ABORT_REMAIN_ON_CHAN_IND);
	CASE_RETURN_STRING(eWNI_SME_UPDATE_NOA);
	CASE_RETURN_STRING(eWNI_SME_CLEAR_DFS_CHANNEL_LIST);
	CASE_RETURN_STRING(eWNI_SME_CLEAR_LIM_SCAN_CACHE);
	CASE_RETURN_STRING(eWNI_SME_PRE_CHANNEL_SWITCH_FULL_POWER);
	CASE_RETURN_STRING(eWNI_SME_GET_SNR_REQ);
	CASE_RETURN_STRING(eWNI_SME_LINK_STATUS_IND);
	CASE_RETURN_STRING(eWNI_SME_FW_STATUS_IND);

	CASE_RETURN_STRING(eWNI_PMC_MSG_TYPES_BEGIN);

	//General Power Save Messages
	CASE_RETURN_STRING(eWNI_PMC_PWR_SAVE_CFG);

	//BMPS Messages
	CASE_RETURN_STRING(eWNI_PMC_ENTER_BMPS_REQ);
	CASE_RETURN_STRING(eWNI_PMC_ENTER_BMPS_RSP);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_BMPS_REQ);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_BMPS_RSP);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_BMPS_IND);

	//IMPS Messages.
	CASE_RETURN_STRING(eWNI_PMC_ENTER_IMPS_REQ);
	CASE_RETURN_STRING(eWNI_PMC_ENTER_IMPS_RSP);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_IMPS_REQ);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_IMPS_RSP);

	//UAPSD Messages
	CASE_RETURN_STRING(eWNI_PMC_ENTER_UAPSD_REQ);
	CASE_RETURN_STRING(eWNI_PMC_ENTER_UAPSD_RSP);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_UAPSD_REQ);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_UAPSD_RSP);

	CASE_RETURN_STRING(eWNI_PMC_SMPS_STATE_IND);
	CASE_RETURN_STRING(eWNI_PMC_WOWL_ADD_BCAST_PTRN);
	CASE_RETURN_STRING(eWNI_PMC_WOWL_DEL_BCAST_PTRN);
	CASE_RETURN_STRING(eWNI_PMC_ENTER_WOWL_REQ);
	CASE_RETURN_STRING(eWNI_PMC_ENTER_WOWL_RSP);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_WOWL_REQ);
	CASE_RETURN_STRING(eWNI_PMC_EXIT_WOWL_RSP);

#ifdef WLAN_FEATURE_PACKET_FILTERING
	CASE_RETURN_STRING(eWNI_PMC_PACKET_COALESCING_FILTER_MATCH_COUNT_RSP);
#endif // WLAN_FEATURE_PACKET_FILTERING
#if defined WLAN_FEATURE_VOWIFI
	CASE_RETURN_STRING(eWNI_SME_RRM_MSG_TYPE_BEGIN);
	CASE_RETURN_STRING(eWNI_SME_NEIGHBOR_REPORT_REQ_IND);
	CASE_RETURN_STRING(eWNI_SME_NEIGHBOR_REPORT_IND);
	CASE_RETURN_STRING(eWNI_SME_BEACON_REPORT_REQ_IND);
	CASE_RETURN_STRING(eWNI_SME_BEACON_REPORT_RESP_XMIT_IND);
#endif
	CASE_RETURN_STRING(eWNI_SME_ADD_STA_SELF_REQ);
	CASE_RETURN_STRING(eWNI_SME_ADD_STA_SELF_RSP);
	CASE_RETURN_STRING(eWNI_SME_DEL_STA_SELF_REQ);
	CASE_RETURN_STRING(eWNI_SME_DEL_STA_SELF_RSP);
#if defined WLAN_FEATURE_VOWIFI_11R
	CASE_RETURN_STRING(eWNI_SME_FT_PRE_AUTH_REQ);
	CASE_RETURN_STRING(eWNI_SME_FT_PRE_AUTH_RSP);
	CASE_RETURN_STRING(eWNI_SME_FT_UPDATE_KEY);
	CASE_RETURN_STRING(eWNI_SME_FT_AGGR_QOS_REQ);
	CASE_RETURN_STRING(eWNI_SME_FT_AGGR_QOS_RSP);
#endif
#if defined FEATURE_WLAN_ESE
	CASE_RETURN_STRING(eWNI_SME_ESE_ADJACENT_AP_REPORT);
#endif
	CASE_RETURN_STRING(eWNI_SME_REGISTER_MGMT_FRAME_REQ);
#ifdef FEATURE_WLAN_SCAN_PNO
	CASE_RETURN_STRING(eWNI_SME_PREF_NETWORK_FOUND_IND);
#endif // FEATURE_WLAN_SCAN_PNO
	CASE_RETURN_STRING(eWNI_SME_TX_PER_HIT_IND);
	CASE_RETURN_STRING(eWNI_SME_CHANGE_COUNTRY_CODE);
	CASE_RETURN_STRING(eWNI_SME_GENERIC_CHANGE_COUNTRY_CODE);
	CASE_RETURN_STRING(eWNI_SME_PRE_SWITCH_CHL_IND);
	CASE_RETURN_STRING(eWNI_SME_POST_SWITCH_CHL_IND);
	CASE_RETURN_STRING(eWNI_SME_MAX_ASSOC_EXCEEDED);
	CASE_RETURN_STRING(eWNI_SME_BTAMP_LOG_LINK_IND);//to serialize the create/accpet LL req from HCI
#ifdef WLAN_FEATURE_GTK_OFFLOAD
	CASE_RETURN_STRING(eWNI_PMC_GTK_OFFLOAD_GETINFO_RSP);
#endif // WLAN_FEATURE_GTK_OFFLOAD
	CASE_RETURN_STRING(eWNI_SME_ROAM_SCAN_OFFLOAD_RSP);
#ifdef FEATURE_WLAN_LPHB
	CASE_RETURN_STRING(eWNI_SME_LPHB_IND);
#endif /* FEATURE_WLAN_LPHB */
#ifdef FEATURE_WLAN_CH_AVOID
	CASE_RETURN_STRING(eWNI_SME_CH_AVOID_IND);
#endif /* FEATURE_WLAN_CH_AVOID */
#ifdef WLAN_WAKEUP_EVENTS
	CASE_RETURN_STRING(eWNI_SME_WAKE_REASON_IND);
#endif // WLAN_WAKEUP_EVENTS
	CASE_RETURN_STRING(eWNI_SME_EXCLUDE_UNENCRYPTED);
	CASE_RETURN_STRING(eWNI_SME_RSSI_IND); //RSSI indication from TL to be serialized on MC thread
#ifdef FEATURE_WLAN_TDLS
	CASE_RETURN_STRING(eWNI_SME_TDLS_SEND_MGMT_REQ);
	CASE_RETURN_STRING(eWNI_SME_TDLS_SEND_MGMT_RSP);
	CASE_RETURN_STRING(eWNI_SME_TDLS_ADD_STA_REQ);
	CASE_RETURN_STRING(eWNI_SME_TDLS_ADD_STA_RSP);
	CASE_RETURN_STRING(eWNI_SME_TDLS_DEL_STA_REQ);
	CASE_RETURN_STRING(eWNI_SME_TDLS_DEL_STA_RSP);
	CASE_RETURN_STRING(eWNI_SME_TDLS_DEL_STA_IND);
	CASE_RETURN_STRING(eWNI_SME_TDLS_DEL_ALL_PEER_IND);
	CASE_RETURN_STRING(eWNI_SME_MGMT_FRM_TX_COMPLETION_IND);
	CASE_RETURN_STRING(eWNI_SME_TDLS_LINK_ESTABLISH_REQ);
	CASE_RETURN_STRING(eWNI_SME_TDLS_LINK_ESTABLISH_RSP);
#endif
	CASE_RETURN_STRING(eWNI_SME_SET_BCN_FILTER_REQ);
	CASE_RETURN_STRING(eWNI_SME_RESET_AP_CAPS_CHANGED);
#ifdef WLAN_FEATURE_11W
	CASE_RETURN_STRING(eWNI_SME_UNPROT_MGMT_FRM_IND);
#endif
	CASE_RETURN_STRING(eWNI_SME_CANDIDATE_FOUND_IND);
	CASE_RETURN_STRING(eWNI_SME_HANDOFF_REQ);
#ifdef WLAN_FEATURE_RMC
	CASE_RETURN_STRING(eWNI_SME_ENABLE_RMC_REQ);
	CASE_RETURN_STRING(eWNI_SME_DISABLE_RMC_REQ);
	CASE_RETURN_STRING(eWNI_SME_IBSS_PEER_INFO_RSP);
#endif
	CASE_RETURN_STRING(eWNI_SME_GET_TSM_STATS_REQ);
	CASE_RETURN_STRING(eWNI_SME_GET_TSM_STATS_RSP);
	CASE_RETURN_STRING(eWNI_SME_TSM_IE_IND);
	CASE_RETURN_STRING(eWNI_SME_READY_TO_SUSPEND_IND);
#ifdef WLAN_FEATURE_ROAM_OFFLOAD
	CASE_RETURN_STRING(eWNI_SME_ROAM_OFFLOAD_SYNCH_IND);
#endif
#ifdef WLAN_FEATURE_EXTWOW_SUPPORT
	CASE_RETURN_STRING(eWNI_SME_READY_TO_EXTWOW_IND);
#endif
	CASE_RETURN_STRING(eWNI_SME_MSG_GET_TEMPERATURE_IND);
	CASE_RETURN_STRING(eWNI_SME_SNR_IND);
#ifdef FEATURE_WLAN_EXTSCAN
	CASE_RETURN_STRING(eWNI_SME_EXTSCAN_FULL_SCAN_RESULT_IND);
	CASE_RETURN_STRING(eWNI_SME_EPNO_NETWORK_FOUND_IND);
#endif
	CASE_RETURN_STRING(eWNI_SME_SET_THERMAL_LEVEL_IND);
	CASE_RETURN_STRING(eWNI_SME_OCB_SET_CONFIG_RSP);
	CASE_RETURN_STRING(eWNI_SME_OCB_GET_TSF_TIMER_RSP);
	CASE_RETURN_STRING(eWNI_SME_DCC_GET_STATS_RSP);
	CASE_RETURN_STRING(eWNI_SME_DCC_UPDATE_NDL_RSP);
	CASE_RETURN_STRING(eWNI_SME_DCC_STATS_EVENT);
	CASE_RETURN_STRING(eWNI_SME_RADIO_CHAN_STATS_IND);
	CASE_RETURN_STRING(eWNI_SME_TSF_EVENT);
	CASE_RETURN_STRING(eWNI_SME_FW_DUMP_IND);
	CASE_RETURN_STRING(eWNI_SME_PDEV_SET_HT_VHT_IE);
	CASE_RETURN_STRING(eWNI_SME_EXT_CHANGE_CHANNEL);
	CASE_RETURN_STRING(eWNI_SME_EXT_CHANGE_CHANNEL_IND);
	CASE_RETURN_STRING(eWNI_SME_LOST_LINK_INFO_IND);
	CASE_RETURN_STRING(eWNI_SME_GET_PEER_INFO_IND);
	CASE_RETURN_STRING(eWNI_SME_GET_PEER_INFO_EXT_IND);
	CASE_RETURN_STRING(eWNI_SME_ROAM_SCAN_OFFLOAD_REQ);
	CASE_RETURN_STRING(eWNI_SME_SMPS_FORCE_MODE_IND);
	CASE_RETURN_STRING(eWNI_SME_REGISTER_MGMT_FRAME_CB);
#ifdef WLAN_FEATURE_NAN
	CASE_RETURN_STRING(eWNI_SME_NAN_EVENT);
#endif
	CASE_RETURN_STRING(eWNI_SME_REGISTER_P2P_ACK_CB);
	CASE_RETURN_STRING(eWNI_SME_MSG_TYPES_END);
	default:
		return((tANI_U8*)"UNKNOWN");
		break;
	}
}


tANI_U8* macTraceGetWdaMsgString(tANI_U16 wdaMsg)
{
	switch(wdaMsg)
	{
	CASE_RETURN_STRING(WDA_APP_SETUP_NTF);
	CASE_RETURN_STRING(WDA_NIC_OPER_NTF);
	CASE_RETURN_STRING(WDA_INIT_START_REQ);
	CASE_RETURN_STRING(WDA_RESET_REQ);
	CASE_RETURN_STRING(WDA_HDD_ADDBA_REQ);
	CASE_RETURN_STRING(WDA_HDD_ADDBA_RSP);
	CASE_RETURN_STRING(WDA_DELETEBA_IND);
	CASE_RETURN_STRING(WDA_TL_FLUSH_AC_REQ);
	CASE_RETURN_STRING(WDA_TL_FLUSH_AC_RSP);

	CASE_RETURN_STRING(WDA_ITC_MSG_TYPES_BEGIN);
	CASE_RETURN_STRING(WDA_WDT_KAM_RSP);
	CASE_RETURN_STRING(WDA_TIMER_TEMP_MEAS_REQ);
	CASE_RETURN_STRING(WDA_TIMER_PERIODIC_STATS_COLLECT_REQ);
	CASE_RETURN_STRING(WDA_CAL_REQ_NTF);
	CASE_RETURN_STRING(WDA_MNT_OPEN_TPC_TEMP_MEAS_REQ);
	CASE_RETURN_STRING(WDA_CCA_MONITOR_INTERVAL_TO);
	CASE_RETURN_STRING(WDA_CCA_MONITOR_DURATION_TO);
	CASE_RETURN_STRING(WDA_CCA_MONITOR_START);
	CASE_RETURN_STRING(WDA_CCA_MONITOR_STOP);
	CASE_RETURN_STRING(WDA_CCA_CHANGE_MODE);
	CASE_RETURN_STRING(WDA_TIMER_WRAP_AROUND_STATS_COLLECT_REQ);

	CASE_RETURN_STRING(WDA_ADD_STA_REQ);
	CASE_RETURN_STRING(WDA_ADD_STA_RSP);
	CASE_RETURN_STRING(WDA_ADD_STA_SELF_RSP);
	CASE_RETURN_STRING(WDA_DEL_STA_SELF_RSP);
	CASE_RETURN_STRING(WDA_DELETE_STA_REQ);
	CASE_RETURN_STRING(WDA_DELETE_STA_RSP);
	CASE_RETURN_STRING(WDA_ADD_BSS_REQ);
	CASE_RETURN_STRING(WDA_ADD_BSS_RSP);
	CASE_RETURN_STRING(WDA_DELETE_BSS_REQ);
	CASE_RETURN_STRING(WDA_DELETE_BSS_RSP);
	CASE_RETURN_STRING(WDA_INIT_SCAN_REQ);
	CASE_RETURN_STRING(WDA_INIT_SCAN_RSP);
	CASE_RETURN_STRING(WDA_START_SCAN_REQ);
	CASE_RETURN_STRING(WDA_START_SCAN_RSP);
	CASE_RETURN_STRING(WDA_END_SCAN_REQ);
	CASE_RETURN_STRING(WDA_END_SCAN_RSP);
	CASE_RETURN_STRING(WDA_FINISH_SCAN_REQ);
	CASE_RETURN_STRING(WDA_FINISH_SCAN_RSP);
	CASE_RETURN_STRING(WDA_SEND_BEACON_REQ);
	CASE_RETURN_STRING(WDA_SEND_BEACON_RSP);

	CASE_RETURN_STRING(WDA_INIT_CFG_REQ);
	CASE_RETURN_STRING(WDA_INIT_CFG_RSP);

	CASE_RETURN_STRING(WDA_INIT_WM_CFG_REQ);
	CASE_RETURN_STRING(WDA_INIT_WM_CFG_RSP);

	CASE_RETURN_STRING(WDA_SET_BSSKEY_REQ);
	CASE_RETURN_STRING(WDA_SET_BSSKEY_RSP);
	CASE_RETURN_STRING(WDA_SET_STAKEY_REQ);
	CASE_RETURN_STRING(WDA_SET_STAKEY_RSP);
	CASE_RETURN_STRING(WDA_DPU_STATS_REQ);
	CASE_RETURN_STRING(WDA_DPU_STATS_RSP);
	CASE_RETURN_STRING(WDA_GET_DPUINFO_REQ);
	CASE_RETURN_STRING(WDA_GET_DPUINFO_RSP);

	CASE_RETURN_STRING(WDA_UPDATE_EDCA_PROFILE_IND);

	CASE_RETURN_STRING(WDA_UPDATE_STARATEINFO_REQ);
	CASE_RETURN_STRING(WDA_UPDATE_STARATEINFO_RSP);

	CASE_RETURN_STRING(WDA_UPDATE_BEACON_IND);
	CASE_RETURN_STRING(WDA_UPDATE_CF_IND);
	CASE_RETURN_STRING(WDA_CHNL_SWITCH_REQ);
	CASE_RETURN_STRING(WDA_ADD_TS_REQ);
	CASE_RETURN_STRING(WDA_DEL_TS_REQ);
	CASE_RETURN_STRING(WDA_SOFTMAC_TXSTAT_REPORT);
	CASE_RETURN_STRING(WDA_MBOX_SENDMSG_COMPLETE_IND);
	CASE_RETURN_STRING(WDA_EXIT_BMPS_REQ);
	CASE_RETURN_STRING(WDA_EXIT_BMPS_RSP);
	CASE_RETURN_STRING(WDA_EXIT_BMPS_IND);
	CASE_RETURN_STRING(WDA_ENTER_BMPS_REQ);
	CASE_RETURN_STRING(WDA_ENTER_BMPS_RSP);
	CASE_RETURN_STRING(WDA_BMPS_STATUS_IND);
	CASE_RETURN_STRING(WDA_MISSED_BEACON_IND);

	CASE_RETURN_STRING(WDA_CFG_RXP_FILTER_REQ);
	CASE_RETURN_STRING(WDA_CFG_RXP_FILTER_RSP);
	CASE_RETURN_STRING(WDA_SWITCH_CHANNEL_RSP);
	CASE_RETURN_STRING(WDA_P2P_NOA_ATTR_IND);
	CASE_RETURN_STRING(WDA_P2P_NOA_START_IND);
	CASE_RETURN_STRING(WDA_PWR_SAVE_CFG);

	CASE_RETURN_STRING(WDA_REGISTER_PE_CALLBACK);
	CASE_RETURN_STRING(WDA_SOFTMAC_MEM_READREQUEST);
	CASE_RETURN_STRING(WDA_SOFTMAC_MEM_WRITEREQUEST);

	CASE_RETURN_STRING(WDA_SOFTMAC_MEM_READRESPONSE);
	CASE_RETURN_STRING(WDA_SOFTMAC_BULKREGWRITE_CONFIRM);
	CASE_RETURN_STRING(WDA_SOFTMAC_BULKREGREAD_RESPONSE);
	CASE_RETURN_STRING(WDA_SOFTMAC_HOSTMESG_MSGPROCESSRESULT);

	CASE_RETURN_STRING(WDA_MIC_FAILURE_IND);

	CASE_RETURN_STRING(WDA_DELBA_REQ);
	CASE_RETURN_STRING(WDA_IBSS_STA_ADD);
	CASE_RETURN_STRING(WDA_TIMER_ADJUST_ADAPTIVE_THRESHOLD_IND);
	CASE_RETURN_STRING(WDA_SET_LINK_STATE);
	CASE_RETURN_STRING(WDA_SET_LINK_STATE_RSP);
	CASE_RETURN_STRING(WDA_ENTER_IMPS_REQ);
	CASE_RETURN_STRING(WDA_ENTER_IMPS_RSP);
	CASE_RETURN_STRING(WDA_EXIT_IMPS_RSP);
	CASE_RETURN_STRING(WDA_EXIT_IMPS_REQ);
	CASE_RETURN_STRING(WDA_SOFTMAC_HOSTMESG_PS_STATUS_IND);
	CASE_RETURN_STRING(WDA_POSTPONE_ENTER_IMPS_RSP);
	CASE_RETURN_STRING(WDA_STA_STAT_REQ);
	CASE_RETURN_STRING(WDA_GLOBAL_STAT_REQ);
	CASE_RETURN_STRING(WDA_AGGR_STAT_REQ);
	CASE_RETURN_STRING(WDA_STA_STAT_RSP);
	CASE_RETURN_STRING(WDA_GLOBAL_STAT_RSP);
	CASE_RETURN_STRING(WDA_AGGR_STAT_RSP);
	CASE_RETURN_STRING(WDA_STAT_SUMM_REQ);
	CASE_RETURN_STRING(WDA_STAT_SUMM_RSP);
	CASE_RETURN_STRING(WDA_REMOVE_BSSKEY_REQ);
	CASE_RETURN_STRING(WDA_REMOVE_BSSKEY_RSP);
	CASE_RETURN_STRING(WDA_REMOVE_STAKEY_REQ);
	CASE_RETURN_STRING(WDA_REMOVE_STAKEY_RSP);
	CASE_RETURN_STRING(WDA_SET_STA_BCASTKEY_REQ);
	CASE_RETURN_STRING(WDA_SET_STA_BCASTKEY_RSP);
	CASE_RETURN_STRING(WDA_REMOVE_STA_BCASTKEY_REQ);
	CASE_RETURN_STRING(WDA_REMOVE_STA_BCASTKEY_RSP);
	CASE_RETURN_STRING(WDA_ADD_TS_RSP);
	CASE_RETURN_STRING(WDA_DPU_MIC_ERROR);

	CASE_RETURN_STRING(WDA_TIMER_BA_ACTIVITY_REQ);
	CASE_RETURN_STRING(WDA_TIMER_CHIP_MONITOR_TIMEOUT);
	CASE_RETURN_STRING(WDA_TIMER_TRAFFIC_ACTIVITY_REQ);
	CASE_RETURN_STRING(WDA_TIMER_ADC_RSSI_STATS);
#ifdef WLAN_FEATURE_11W
	CASE_RETURN_STRING(WDA_EXCLUDE_UNENCRYPTED_IND);
#endif
#ifdef FEATURE_WLAN_ESE
	CASE_RETURN_STRING(WDA_TSM_STATS_REQ);
	CASE_RETURN_STRING(WDA_TSM_STATS_RSP);
#endif
	CASE_RETURN_STRING(WDA_UPDATE_UAPSD_IND);
	CASE_RETURN_STRING(WDA_SET_MIMOPS_REQ);
	CASE_RETURN_STRING(WDA_SET_MIMOPS_RSP);
	CASE_RETURN_STRING(WDA_SYS_READY_IND );
	CASE_RETURN_STRING(WDA_SET_TX_POWER_REQ);
	CASE_RETURN_STRING(WDA_SET_TX_POWER_RSP);
	CASE_RETURN_STRING(WDA_GET_TX_POWER_REQ);
	CASE_RETURN_STRING(WDA_GET_NOISE_REQ );
	CASE_RETURN_STRING(WDA_SET_TX_PER_TRACKING_REQ);

	CASE_RETURN_STRING(WDA_TRANSMISSION_CONTROL_IND);
	CASE_RETURN_STRING(WDA_INIT_RADAR_IND);

	CASE_RETURN_STRING(WDA_BEACON_PRE_IND );
	CASE_RETURN_STRING(WDA_ENTER_UAPSD_REQ);
	CASE_RETURN_STRING(WDA_ENTER_UAPSD_RSP);
	CASE_RETURN_STRING(WDA_EXIT_UAPSD_REQ  );
	CASE_RETURN_STRING(WDA_EXIT_UAPSD_RSP );
	CASE_RETURN_STRING(WDA_BEACON_FILTER_IND);
	CASE_RETURN_STRING(WDA_WOWL_ADD_BCAST_PTRN);
	CASE_RETURN_STRING(WDA_WOWL_DEL_BCAST_PTRN);
	CASE_RETURN_STRING(WDA_WOWL_ENTER_REQ);
	CASE_RETURN_STRING(WDA_WOWL_ENTER_RSP);
	CASE_RETURN_STRING(WDA_WOWL_EXIT_REQ );
	CASE_RETURN_STRING(WDA_WOWL_EXIT_RSP );
	CASE_RETURN_STRING(WDA_TX_COMPLETE_IND);
	CASE_RETURN_STRING(WDA_TIMER_RA_COLLECT_AND_ADAPT);
	CASE_RETURN_STRING(WDA_GET_STATISTICS_REQ);
	CASE_RETURN_STRING(WDA_GET_STATISTICS_RSP);
	CASE_RETURN_STRING(WDA_SET_KEY_DONE);

	CASE_RETURN_STRING(WDA_BTC_SET_CFG);
	CASE_RETURN_STRING(WDA_SIGNAL_BT_EVENT);
	CASE_RETURN_STRING(WDA_HANDLE_FW_MBOX_RSP);
	CASE_RETURN_STRING(WDA_SEND_PROBE_RSP_TMPL);
#ifdef FEATURE_OEM_DATA_SUPPORT
	CASE_RETURN_STRING(WDA_START_OEM_DATA_REQ );
	CASE_RETURN_STRING(WDA_START_OEM_DATA_RSP);
	CASE_RETURN_STRING(WDA_FINISH_OEM_DATA_REQ);
#endif //SUPPORT_BEACON_FILTER
	CASE_RETURN_STRING(WDA_SET_MAX_TX_POWER_REQ);
	CASE_RETURN_STRING(WDA_SET_MAX_TX_POWER_RSP);
	CASE_RETURN_STRING(WDA_SET_MAX_TX_POWER_PER_BAND_RSP);
	CASE_RETURN_STRING(WDA_SET_MAX_TX_POWER_PER_BAND_REQ);
	CASE_RETURN_STRING(WDA_SEND_MSG_COMPLETE);
	CASE_RETURN_STRING(WDA_SET_HOST_OFFLOAD);
	CASE_RETURN_STRING(WDA_SET_KEEP_ALIVE);
#ifdef WLAN_NS_OFFLOAD
	CASE_RETURN_STRING(WDA_SET_NS_OFFLOAD);
#endif //WLAN_NS_OFFLOAD
	CASE_RETURN_STRING(WDA_ADD_STA_SELF_REQ);
	CASE_RETURN_STRING(WDA_DEL_STA_SELF_REQ);
	CASE_RETURN_STRING(WDA_SET_P2P_GO_NOA_REQ);
#ifdef FEATURE_WLAN_TDLS
	CASE_RETURN_STRING(WDA_SET_TDLS_LINK_ESTABLISH_REQ);
	CASE_RETURN_STRING(WDA_SET_TDLS_LINK_ESTABLISH_REQ_RSP);
#endif
	CASE_RETURN_STRING(WDA_TX_COMPLETE_TIMEOUT_IND);
	CASE_RETURN_STRING(WDA_TIMER_TRAFFIC_STATS_IND);
	CASE_RETURN_STRING(WDA_WLAN_SUSPEND_IND);
	CASE_RETURN_STRING(WDA_WLAN_RESUME_REQ);
#ifdef WLAN_FEATURE_EXTWOW_SUPPORT
	CASE_RETURN_STRING(WDA_WLAN_EXT_WOW);
	CASE_RETURN_STRING(WDA_WLAN_SET_APP_TYPE1_PARAMS);
	CASE_RETURN_STRING(WDA_WLAN_SET_APP_TYPE2_PARAMS);
#endif
	CASE_RETURN_STRING(WDA_MSG_TYPES_END);
	CASE_RETURN_STRING(WDA_MMH_TXMB_READY_EVT);
	CASE_RETURN_STRING(WDA_MMH_RXMB_DONE_EVT);
	CASE_RETURN_STRING(WDA_MMH_MSGQ_NE_EVT);
#ifdef WLAN_FEATURE_VOWIFI_11R
	CASE_RETURN_STRING(WDA_AGGR_QOS_REQ);
	CASE_RETURN_STRING(WDA_AGGR_QOS_RSP);
#endif /* WLAN_FEATURE_VOWIFI_11R */
	CASE_RETURN_STRING(WDA_FTM_CMD_REQ);
	CASE_RETURN_STRING(WDA_FTM_CMD_RSP);
#ifdef FEATURE_WLAN_SCAN_PNO
	CASE_RETURN_STRING(WDA_SET_PNO_REQ);
	CASE_RETURN_STRING(WDA_UPDATE_SCAN_PARAMS_REQ);
	CASE_RETURN_STRING(WDA_SET_PNO_CHANGED_IND);
	CASE_RETURN_STRING(WDA_SME_SCAN_CACHE_UPDATED);
#endif // FEATURE_WLAN_SCAN_PNO
#ifdef WLAN_FEATURE_ROAM_SCAN_OFFLOAD
	CASE_RETURN_STRING(WDA_ROAM_SCAN_OFFLOAD_REQ);
	CASE_RETURN_STRING(WDA_ROAM_SCAN_OFFLOAD_RSP);
#endif
#ifdef WLAN_WAKEUP_EVENTS
	CASE_RETURN_STRING(WDA_WAKE_REASON_IND);
#endif // WLAN_WAKEUP_EVENTS
#ifdef WLAN_FEATURE_PACKET_FILTERING
	CASE_RETURN_STRING(WDA_8023_MULTICAST_LIST_REQ);
	CASE_RETURN_STRING(WDA_RECEIVE_FILTER_SET_FILTER_REQ);
	CASE_RETURN_STRING(WDA_PACKET_COALESCING_FILTER_MATCH_COUNT_REQ);
	CASE_RETURN_STRING(WDA_PACKET_COALESCING_FILTER_MATCH_COUNT_RSP);
	CASE_RETURN_STRING(WDA_RECEIVE_FILTER_CLEAR_FILTER_REQ);
#endif // WLAN_FEATURE_PACKET_FILTERING
	CASE_RETURN_STRING(WDA_SET_POWER_PARAMS_REQ);
#ifdef WLAN_FEATURE_GTK_OFFLOAD
	CASE_RETURN_STRING(WDA_GTK_OFFLOAD_REQ);
	CASE_RETURN_STRING(WDA_GTK_OFFLOAD_GETINFO_REQ);
	CASE_RETURN_STRING(WDA_GTK_OFFLOAD_GETINFO_RSP);
#endif //WLAN_FEATURE_GTK_OFFLOAD
	CASE_RETURN_STRING(WDA_SET_TM_LEVEL_REQ);
#ifdef WLAN_FEATURE_11AC
	CASE_RETURN_STRING(WDA_UPDATE_OP_MODE);
	CASE_RETURN_STRING(WDA_UPDATE_MEMBERSHIP);
	CASE_RETURN_STRING(WDA_UPDATE_USERPOS);
#endif
	CASE_RETURN_STRING(WDA_START_SCAN_OFFLOAD_REQ);
	CASE_RETURN_STRING(WDA_START_SCAN_OFFLOAD_RSP);
	CASE_RETURN_STRING(WDA_STOP_SCAN_OFFLOAD_REQ);
	CASE_RETURN_STRING(WDA_STOP_SCAN_OFFLOAD_RSP);
	CASE_RETURN_STRING(WDA_UPDATE_CHAN_LIST_REQ);
	CASE_RETURN_STRING(WDA_UPDATE_CHAN_LIST_RSP);
	CASE_RETURN_STRING(WDA_RX_SCAN_EVENT);
	CASE_RETURN_STRING(WDA_RX_CHN_STATUS_EVENT);
	CASE_RETURN_STRING(WDA_IBSS_PEER_INACTIVITY_IND);
	CASE_RETURN_STRING(WDA_CLI_SET_CMD);
	CASE_RETURN_STRING(WDA_CLI_GET_CMD);
#ifndef REMOVE_PKT_LOG
	CASE_RETURN_STRING(WDA_PKTLOG_ENABLE_REQ);
#endif
#if defined(FEATURE_WLAN_ESE) && defined(FEATURE_WLAN_ESE_UPLOAD)
	CASE_RETURN_STRING(WDA_SET_PLM_REQ);
#endif
	CASE_RETURN_STRING(WDA_CONFIG_PARAM_UPDATE_REQ);
	CASE_RETURN_STRING(WDA_RATE_UPDATE_IND);
#ifdef FEATURE_WLAN_TDLS
	CASE_RETURN_STRING(WDA_UPDATE_FW_TDLS_STATE);
	CASE_RETURN_STRING(WDA_UPDATE_TDLS_PEER_STATE);
#endif
	CASE_RETURN_STRING(WDA_ADD_PERIODIC_TX_PTRN_IND);
	CASE_RETURN_STRING(WDA_TX_POWER_LIMIT);
#ifdef FEATURE_WLAN_LPHB
	CASE_RETURN_STRING(WDA_LPHB_CONF_REQ);
#endif
	CASE_RETURN_STRING(WDA_DHCP_START_IND);
	CASE_RETURN_STRING(WDA_DHCP_STOP_IND);
#ifdef FEATURE_WLAN_CH_AVOID
	CASE_RETURN_STRING(WDA_CH_AVOID_UPDATE_REQ);
#endif
#ifdef FEATURE_WLAN_AUTO_SHUTDOWN
	CASE_RETURN_STRING(WDA_SET_AUTO_SHUTDOWN_TIMER_REQ);
#endif

	CASE_RETURN_STRING(WDA_IBSS_CESIUM_ENABLE_IND);
	CASE_RETURN_STRING(WDA_GET_IBSS_PEER_INFO_REQ);
	CASE_RETURN_STRING(WDA_TX_FAIL_MONITOR_IND);

	CASE_RETURN_STRING(WDA_RMC_ENABLE_IND);
	CASE_RETURN_STRING(WDA_RMC_DISABLE_IND);
	CASE_RETURN_STRING(WDA_RMC_ACTION_PERIOD_IND);

	CASE_RETURN_STRING(WDA_INIT_THERMAL_INFO_CMD);
	CASE_RETURN_STRING(WDA_SET_THERMAL_LEVEL);
	CASE_RETURN_STRING(WDA_SET_SAP_INTRABSS_DIS);
	CASE_RETURN_STRING(WDA_FW_STATS_IND);
	CASE_RETURN_STRING(WDA_VDEV_STOP_IND);
	CASE_RETURN_STRING(WDA_TBTT_UPDATE_IND);
#ifdef WLAN_FEATURE_ROAM_OFFLOAD
	CASE_RETURN_STRING(WDA_ROAM_OFFLOAD_SYNCH_CNF);
	CASE_RETURN_STRING(WDA_ROAM_OFFLOAD_SYNCH_FAIL);
#endif
	CASE_RETURN_STRING(SIR_HAL_SET_BASE_MACADDR_IND);
	CASE_RETURN_STRING(WDA_LINK_STATUS_GET_REQ);
	CASE_RETURN_STRING(WDA_GET_FW_STATUS_REQ);
#ifdef DHCP_SERVER_OFFLOAD
	CASE_RETURN_STRING(WDA_SET_DHCP_SERVER_OFFLOAD_CMD);
#endif
#ifdef MDNS_OFFLOAD
	CASE_RETURN_STRING(WDA_SET_MDNS_OFFLOAD_CMD);
	CASE_RETURN_STRING(WDA_SET_MDNS_FQDN_CMD);
	CASE_RETURN_STRING(WDA_SET_MDNS_RESPONSE_CMD);
	CASE_RETURN_STRING(WDA_GET_MDNS_STATUS_CMD);
#endif
#ifdef WLAN_FEATURE_APFIND
	CASE_RETURN_STRING(WDA_APFIND_SET_CMD);
#endif /*WLAN_FEATURE_APFIND*/
#ifdef FEATURE_RUNTIME_PM
	CASE_RETURN_STRING(WDA_RUNTIME_PM_SUSPEND_IND);
	CASE_RETURN_STRING(WDA_RUNTIME_PM_RESUME_IND);
#endif
	CASE_RETURN_STRING(WDA_OCB_SET_CONFIG_CMD);
	CASE_RETURN_STRING(WDA_OCB_SET_UTC_TIME_CMD);
	CASE_RETURN_STRING(WDA_OCB_START_TIMING_ADVERT_CMD);
	CASE_RETURN_STRING(WDA_OCB_STOP_TIMING_ADVERT_CMD);
	CASE_RETURN_STRING(WDA_OCB_GET_TSF_TIMER_CMD);
	CASE_RETURN_STRING(WDA_DCC_GET_STATS_CMD);
	CASE_RETURN_STRING(WDA_DCC_CLEAR_STATS_CMD);
	CASE_RETURN_STRING(WDA_DCC_UPDATE_NDL_CMD);
	CASE_RETURN_STRING(WNI_CFG_DNLD_REQ);
	CASE_RETURN_STRING(WDA_SET_PDEV_IE_REQ);
#ifdef WLAN_FEATURE_11AC
	CASE_RETURN_STRING(WDA_UPDATE_RX_NSS);
#endif
#ifdef FEATURE_WLAN_TDLS
	CASE_RETURN_STRING(WDA_TDLS_SET_OFFCHAN_MODE);
#endif
	CASE_RETURN_STRING(WDA_DEL_PERIODIC_TX_PTRN_IND);
	CASE_RETURN_STRING(WDA_INIT_BAD_PEER_TX_CTL_INFO_CMD);
	CASE_RETURN_STRING(WDA_GET_LINK_SPEED);
	CASE_RETURN_STRING(WDA_MODEM_POWER_STATE_IND);
#ifdef WLAN_FEATURE_STATS_EXT
	CASE_RETURN_STRING(WDA_STATS_EXT_REQUEST);
#endif
	CASE_RETURN_STRING(WDA_HIDDEN_SSID_VDEV_RESTART);
	CASE_RETURN_STRING(WDA_VDEV_START_RSP_IND);
	CASE_RETURN_STRING(WDA_ROAM_PREAUTH_IND);
#ifdef FEATURE_WLAN_EXTSCAN
	CASE_RETURN_STRING(WDA_EXTSCAN_START_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_STOP_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_SET_BSSID_HOTLIST_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_RESET_BSSID_HOTLIST_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_SET_SIGNF_CHANGE_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_RESET_SIGNF_CHANGE_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_GET_CACHED_RESULTS_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_GET_CAPABILITIES_REQ);
	CASE_RETURN_STRING(WDA_EXTSCAN_STATUS_IND);
	CASE_RETURN_STRING(WDA_EXTSCAN_OPERATION_IND);
	CASE_RETURN_STRING(WDA_SET_EPNO_LIST_REQ);
	CASE_RETURN_STRING(WDA_SET_PASSPOINT_LIST_REQ);
	CASE_RETURN_STRING(WDA_RESET_PASSPOINT_LIST_REQ);
#endif
	CASE_RETURN_STRING(WDA_SET_SCAN_MAC_OUI_REQ);
#ifdef WLAN_FEATURE_LINK_LAYER_STATS
	CASE_RETURN_STRING(WDA_LINK_LAYER_STATS_CLEAR_REQ);
	CASE_RETURN_STRING(WDA_LINK_LAYER_STATS_SET_REQ);
	CASE_RETURN_STRING(WDA_LINK_LAYER_STATS_GET_REQ);
	CASE_RETURN_STRING(WDA_LINK_LAYER_STATS_RESULTS_RSP);
#endif
	CASE_RETURN_STRING(SIR_HAL_UNIT_TEST_CMD);
#ifdef WLAN_FEATURE_ROAM_OFFLOAD
	CASE_RETURN_STRING(SIR_HAL_ROAM_INVOKE);
#endif
#ifdef WLAN_FEATURE_NAN
	CASE_RETURN_STRING(WDA_NAN_REQUEST);
#endif
	CASE_RETURN_STRING(WDA_GET_LINK_STATUS_RSP_IND);
	CASE_RETURN_STRING(WDA_GET_TEMPERATURE_REQ);
#ifdef WLAN_FEATURE_GPIO_LED_FLASHING
	CASE_RETURN_STRING(WDA_LED_FLASHING_REQ);
#endif
	CASE_RETURN_STRING(WDA_IPA_OFFLOAD_ENABLE_DISABLE);
#ifdef SAP_AUTH_OFFLOAD
	CASE_RETURN_STRING(WDA_SET_SAP_AUTH_OFL);
#endif
	CASE_RETURN_STRING(SIR_HAL_SET_MAS);
	CASE_RETURN_STRING(SIR_HAL_SET_MIRACAST);
	CASE_RETURN_STRING(SIR_HAL_CONFIG_STATS_FACTOR);
	CASE_RETURN_STRING(SIR_HAL_CONFIG_GUARD_TIME);
	CASE_RETURN_STRING(WDA_FW_MEM_DUMP_REQ);
	CASE_RETURN_STRING(SIR_HAL_START_STOP_LOGGING);
	CASE_RETURN_STRING(WDA_TSF_GPIO_PIN);
	CASE_RETURN_STRING(SIR_HAL_FLUSH_LOG_TO_FW);
	CASE_RETURN_STRING(WDA_SET_IE_INFO);
	CASE_RETURN_STRING(WDA_SET_RSSI_MONITOR_REQ);
	CASE_RETURN_STRING(WDA_MIB_STATS_REQ);
	CASE_RETURN_STRING(WDA_SET_MIB_STATS_ENABLE);
	CASE_RETURN_STRING(WDA_SET_MIB_STATS_DISABLE);
	CASE_RETURN_STRING(SIR_HAL_POWER_DEBUG_STATS_REQ);
	CASE_RETURN_STRING(WDA_ACTION_FRAME_RANDOM_MAC);
	CASE_RETURN_STRING(SIR_HAL_GET_ISOLATION);
	default:
		return((tANI_U8*) "UNKNOWN");
		break;
	}
}

tANI_U8* macTraceGetLimMsgString(tANI_U16 limMsg)
{
	switch(limMsg)
	{
	CASE_RETURN_STRING(SIR_LIM_RETRY_INTERRUPT_MSG);
	CASE_RETURN_STRING(SIR_BB_XPORT_MGMT_MSG );
	CASE_RETURN_STRING(SIR_LIM_INV_KEY_INTERRUPT_MSG );
	CASE_RETURN_STRING(SIR_LIM_KEY_ID_INTERRUPT_MSG );
	CASE_RETURN_STRING(SIR_LIM_REPLAY_THRES_INTERRUPT_MSG );
	CASE_RETURN_STRING(SIR_LIM_TD_DUMMY_CALLBACK_MSG );
	CASE_RETURN_STRING(SIR_LIM_SCH_CLEAN_MSG  );
	CASE_RETURN_STRING(SIR_LIM_RADAR_DETECT_IND);
	CASE_RETURN_STRING(SIR_LIM_DEL_TS_IND);
	CASE_RETURN_STRING(SIR_LIM_DELETE_STA_CONTEXT_IND);
	CASE_RETURN_STRING(SIR_LIM_UPDATE_BEACON);
	CASE_RETURN_STRING(SIR_LIM_MIN_CHANNEL_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_MAX_CHANNEL_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_JOIN_FAIL_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_AUTH_FAIL_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_AUTH_RSP_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_ASSOC_FAIL_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_REASSOC_FAIL_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_HEART_BEAT_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_CHANNEL_SCAN_TIMEOUT );
	CASE_RETURN_STRING(SIR_LIM_PROBE_HB_FAILURE_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_ADDTS_RSP_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_LINK_TEST_DURATION_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_CNF_WAIT_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_KEEPALIVE_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_UPDATE_OLBC_CACHEL_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_CHANNEL_SWITCH_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_QUIET_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_QUIET_BSS_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_WPS_OVERLAP_TIMEOUT);
#ifdef WLAN_FEATURE_VOWIFI_11R
	CASE_RETURN_STRING(SIR_LIM_FT_PREAUTH_RSP_TIMEOUT);
#endif
	CASE_RETURN_STRING(SIR_LIM_REMAIN_CHN_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_INSERT_SINGLESHOT_NOA_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_CONVERT_ACTIVE_CHANNEL_TO_PASSIVE);
	CASE_RETURN_STRING(SIR_LIM_BEACON_GEN_IND);
	CASE_RETURN_STRING(SIR_LIM_PERIODIC_PROBE_REQ_TIMEOUT);
#ifdef FEATURE_WLAN_ESE
	CASE_RETURN_STRING(SIR_LIM_ESE_TSM_TIMEOUT);
#endif
	CASE_RETURN_STRING(SIR_LIM_DISASSOC_ACK_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_DEAUTH_ACK_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_PERIODIC_JOIN_PROBE_REQ_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_AUTH_RETRY_TIMEOUT);
	CASE_RETURN_STRING(SIR_LIM_MSG_TYPES_END);
	CASE_RETURN_STRING(LIM_MLM_SCAN_REQ);
	CASE_RETURN_STRING(LIM_MLM_SCAN_CNF);
	CASE_RETURN_STRING(LIM_MLM_START_REQ);
	CASE_RETURN_STRING(LIM_MLM_START_CNF);
	CASE_RETURN_STRING(LIM_MLM_JOIN_REQ);
	CASE_RETURN_STRING(LIM_MLM_JOIN_CNF);
	CASE_RETURN_STRING(LIM_MLM_AUTH_REQ);
	CASE_RETURN_STRING(LIM_MLM_AUTH_CNF);
	CASE_RETURN_STRING(LIM_MLM_AUTH_IND);
	CASE_RETURN_STRING(LIM_MLM_ASSOC_REQ);
	CASE_RETURN_STRING(LIM_MLM_ASSOC_CNF);
	CASE_RETURN_STRING(LIM_MLM_ASSOC_IND);
	CASE_RETURN_STRING(LIM_MLM_DISASSOC_REQ);
	CASE_RETURN_STRING(LIM_MLM_DISASSOC_CNF);
	CASE_RETURN_STRING(LIM_MLM_DISASSOC_IND);
	CASE_RETURN_STRING(LIM_MLM_REASSOC_REQ);
	CASE_RETURN_STRING(LIM_MLM_REASSOC_CNF);
	CASE_RETURN_STRING(LIM_MLM_REASSOC_IND);
	CASE_RETURN_STRING(LIM_MLM_DEAUTH_REQ);
	CASE_RETURN_STRING(LIM_MLM_DEAUTH_CNF);
	CASE_RETURN_STRING(LIM_MLM_DEAUTH_IND);
	CASE_RETURN_STRING(LIM_MLM_TSPEC_REQ);
	CASE_RETURN_STRING(LIM_MLM_TSPEC_CNF);
	CASE_RETURN_STRING(LIM_MLM_SETKEYS_REQ);
	CASE_RETURN_STRING(LIM_MLM_SETKEYS_CNF);
	CASE_RETURN_STRING(LIM_MLM_PURGE_STA_IND);
	CASE_RETURN_STRING(LIM_MLM_REMOVEKEY_REQ);
	CASE_RETURN_STRING(LIM_MLM_REMOVEKEY_CNF);
#ifdef FEATURE_OEM_DATA_SUPPORT
	CASE_RETURN_STRING(LIM_MLM_OEM_DATA_REQ);
	CASE_RETURN_STRING(LIM_MLM_OEM_DATA_CNF);
#endif
	default:
		return((tANI_U8*)"UNKNOWN");
		break;
	}
}

tANI_U8* macTraceGetCfgMsgString(tANI_U16 cfgMsg)
{
	switch(cfgMsg)
	{
	CASE_RETURN_STRING(WNI_CFG_PARAM_UPDATE_IND);
	CASE_RETURN_STRING(WNI_CFG_DNLD_REQ);
	CASE_RETURN_STRING(WNI_CFG_DNLD_CNF);
	CASE_RETURN_STRING(WNI_CFG_GET_RSP);
	CASE_RETURN_STRING(WNI_CFG_SET_CNF);
	CASE_RETURN_STRING(SIR_CFG_PARAM_UPDATE_IND);
	CASE_RETURN_STRING(SIR_CFG_DOWNLOAD_COMPLETE_IND);
	CASE_RETURN_STRING(WNI_CFG_DNLD_RSP);
	CASE_RETURN_STRING(WNI_CFG_GET_REQ);
	CASE_RETURN_STRING(WNI_CFG_SET_REQ);
	CASE_RETURN_STRING(WNI_CFG_SET_REQ_NO_RSP);
	default:
		return((tANI_U8*)"UNKNOWN");
		break;
	}
}

tANI_U8* macTraceGetInfoLogString(tANI_U16 infoLog)
{
	switch(infoLog)
	{
	CASE_RETURN_STRING(eLOG_NODROP_MISSED_BEACON_SCENARIO);
	CASE_RETURN_STRING(eLOG_PROC_DEAUTH_FRAME_SCENARIO);
	default:
		return((tANI_U8*)"UNKNOWN");
		break;
	}
}

tANI_U8* macTraceGetModuleString(tANI_U8 moduleId)
{
	return ((tANI_U8*)"PE");
	//return gVosTraceInfo[moduleId].moduleNameStr;
}

void macTraceReset(tpAniSirGlobal pMac)
{
}

void macTrace(tpAniSirGlobal pMac, tANI_U8 code, tANI_U16 session,
	      tANI_U32 data)
{
	/* Today macTrace is being invoked by PE only,
	 * need to remove this function once PE is migrated to using new trace API.
	 */
	macTraceNew(pMac, VOS_MODULE_ID_PE, code, session, data);
}

void macTraceNew(tpAniSirGlobal pMac, tANI_U8 module, tANI_U8 code,
                 tANI_U16 session, tANI_U32 data)
{
	vos_trace(module, code, session, data);
}

tANI_U8* macTraceMsgString(tpAniSirGlobal pMac, tANI_U32 msgType)
{
	tANI_U16 msgId = (tANI_U16)MAC_TRACE_GET_MSG_ID(msgType);
	tANI_U8 moduleId = (tANI_U8)MAC_TRACE_GET_MODULE_ID(msgType);

	switch(moduleId)
	{
	case SIR_LIM_MODULE_ID:
		if(msgId >= SIR_LIM_ITC_MSG_TYPES_BEGIN)
			return macTraceGetLimMsgString((tANI_U16)msgType);
		else
			return macTraceGetSmeMsgString((tANI_U16)msgType);
		break;
	case SIR_WDA_MODULE_ID:
		return macTraceGetWdaMsgString((tANI_U16)msgType);
	case SIR_CFG_MODULE_ID:
		return macTraceGetCfgMsgString((tANI_U16)msgType);
	default:
		return ((tANI_U8*)"Unknown MsgType");
	}
}
#endif
